/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.ConnectException;
import org.mule.transport.xmpp.AbstractXmppConversation;
import org.mule.util.UUID;

public class XmppMultiUserChatConversation
extends AbstractXmppConversation {
    private MultiUserChat chat;
    private String nickname;

    public XmppMultiUserChatConversation(ImmutableEndpoint endpoint) {
        super(endpoint);
        Object nickValue = endpoint.getProperty((Object)"nickname");
        this.nickname = nickValue != null ? nickValue.toString() : UUID.getUUID().toString();
    }

    protected void doConnect() throws ConnectException {
        this.chat = new MultiUserChat(this.connection, this.recipient);
        this.joinChat();
    }

    protected void joinChat() throws ConnectException {
        try {
            this.tryToJoinChat();
        }
        catch (XMPPException e) {
            if (this.roomDoesNotExist(e)) {
                this.createRoom();
            }
            throw new ConnectException((Throwable)e, (Object)this);
        }
    }

    protected void tryToJoinChat() throws XMPPException {
        DiscussionHistory history = new DiscussionHistory();
        history.setMaxStanzas(0);
        long joinTimeout = SmackConfiguration.getPacketReplyTimeout();
        this.chat.join(this.nickname, null, history, joinTimeout);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("joined groupchat '" + this.recipient + "'"));
        }
    }

    protected boolean roomDoesNotExist(XMPPException exception) {
        XMPPError error = exception.getXMPPError();
        return error.getCode() == 404 && error.getCondition().equals(XMPPError.Condition.recipient_unavailable.toString());
    }

    protected void createRoom() throws ConnectException {
        try {
            this.chat.create(this.nickname);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("created and joined groupchat '" + this.recipient + "'"));
            }
        }
        catch (XMPPException e) {
            throw new ConnectException((Throwable)e, (Object)this);
        }
    }

    protected void doDisconnect() {
        this.chat.leave();
    }

    protected PacketCollector createPacketCollector() {
        return null;
    }

    public void dispatch(Message message) throws XMPPException {
        message.setType(Message.Type.groupchat);
        message.setTo(this.recipient);
        this.chat.sendMessage(message);
    }

    public Message receive() {
        return this.chat.nextMessage();
    }

    public Message receive(long timeout) {
        return this.chat.nextMessage(timeout);
    }
}

