/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util.concurrency;

import com.arjuna.common.util.concurrency.Barrier;

public class Rendezvous {
    private int size = 0;
    private int counter = 0;
    private Barrier barrier = null;
    private Object[] locks = null;
    private Object[] tokensIn = null;
    private Object[] tokensOut = null;
    private RendezvousFunction func = null;

    public Rendezvous(int size) {
        this.size = size;
        if (size < 2) {
            throw new IllegalArgumentException("size must be a minimum of 2!");
        }
        this.barrier = new Barrier(size);
        this.locks = new Object[size];
        this.tokensIn = new Object[size];
        this.tokensOut = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.locks[i] = new Object();
        }
        this.func = new Rotator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object enter(int id, Object o) {
        if (id < 0 || id >= this.size) {
            throw new IllegalArgumentException("the id must be within the range 0 =< id < size : " + id);
        }
        Object object = this.locks[id];
        synchronized (object) {
            this.tokensIn[id] = o;
            this.barrier.enter();
            Rendezvous rendezvous = this;
            synchronized (rendezvous) {
                ++this.counter;
                if (this.counter == this.size) {
                    this.func.rendezvousFunction(this.tokensIn, this.tokensOut);
                    this.counter = 0;
                    this.notifyAll();
                }
                if (this.counter != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            return this.tokensOut[id];
        }
    }

    public void setRendezvousFunction(RendezvousFunction func) {
        this.func = func;
    }

    public static class Rotator
    implements RendezvousFunction {
        public void rendezvousFunction(Object[] inObjects, Object[] outObjects) {
            int length = inObjects.length;
            for (int i = 0; i < length; ++i) {
                outObjects[(i + i) % length] = inObjects[i];
            }
        }
    }

    public static interface RendezvousFunction {
        public void rendezvousFunction(Object[] var1, Object[] var2);
    }
}

