/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Document;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transport.OutputHandler;
import org.mule.module.xml.transformer.AbstractXmlTransformer;
import org.mule.module.xml.transformer.DelayedResult;
import org.mule.module.xml.util.XMLUtils;
import org.mule.transformer.types.DataTypeFactory;
import org.w3c.dom.Element;

public class XmlToOutputHandler
extends AbstractXmlTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public XmlToOutputHandler() {
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(Source.class);
        this.registerSourceType(Document.class);
        this.registerSourceType(org.w3c.dom.Document.class);
        this.registerSourceType(Element.class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(OutputHandler.class);
        this.registerSourceType(XMLStreamReader.class);
        this.registerSourceType(DelayedResult.class);
        this.setReturnDataType(DataTypeFactory.create(OutputHandler.class));
    }

    public Object transformMessage(MuleMessage message, final String encoding) {
        final Object src = message.getPayload();
        return new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                XmlToOutputHandler.this.writeXml(src, encoding, out);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeXml(Object src, String encoding, OutputStream out) throws TransformerFactoryConfigurationError, IOException {
        block8: {
            try {
                if (src instanceof XMLStreamReader) {
                    XMLStreamReader reader = (XMLStreamReader)src;
                    XMLStreamWriter writer = this.getXMLOutputFactory().createXMLStreamWriter(out);
                    try {
                        writer.writeStartDocument();
                        XMLUtils.copy(reader, writer);
                        writer.writeEndDocument();
                        break block8;
                    }
                    finally {
                        writer.close();
                        reader.close();
                    }
                }
                if (src instanceof DelayedResult) {
                    DelayedResult result = (DelayedResult)src;
                    StreamResult streamResult = new StreamResult(out);
                    result.write(streamResult);
                } else {
                    this.writeToStream(src, encoding, out);
                }
            }
            catch (Exception e) {
                IOException ioe = new IOException(e.toString());
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

