/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.spi;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.activation.DataSource;
import javax.activation.MimeTypeParseException;
import org.ibeans.api.DataType;
import org.ibeans.api.InvocationContext;
import org.ibeans.api.Response;
import org.ibeans.api.channel.MimeType;
import org.ibeans.impl.support.datatype.DataTypeFactory;
import org.ibeans.impl.test.MockIBean;
import org.ibeans.impl.test.MockMessageCallback;
import org.ibeans.spi.IBeansPlugin;
import org.mule.api.MuleContext;
import org.mule.module.ibeans.spi.MuleCallAnnotationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleMockCallAnnotationHandler
extends MuleCallAnnotationHandler
implements MockIBean {
    private Object mock;
    private InvocationContext ctx;
    private MockMessageCallback callback;
    private IBeansPlugin plugin;

    public MuleMockCallAnnotationHandler(MuleContext muleContext, Object mock, IBeansPlugin plugin) {
        super(muleContext);
        this.mock = mock;
        this.plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response invoke(InvocationContext ctx) throws Exception {
        Response response;
        this.ctx = ctx;
        Method method = ctx.getMethod();
        Object result = method.getName().startsWith("ibean") ? method.invoke((Object)this, ctx.getArgs()) : ctx.getMethod().invoke(this.mock, ctx.getArgs());
        Response response2 = response = result instanceof Response ? (Response)result : this.plugin.createResponse(result, null, null);
        if (this.callback != null) {
            try {
                this.callback.onMessage(response);
            }
            finally {
                this.callback = null;
                this.ctx = null;
            }
        }
        return response;
    }

    @Override
    public String getScheme(Method method) {
        return "http";
    }

    public void ibeanSetMimeType(MimeType mime) throws MimeTypeParseException {
        if (this.ctx.getIBeanConfig().getReturnType() != null) {
            this.ctx.setInvocationReturnType(DataTypeFactory.create((Class)this.ctx.getIBeanConfig().getReturnType().getType(), (MimeType)mime));
        }
    }

    public DataType ibeanReturnType() {
        DataType type = this.ctx.getIBeanConfig().getReturnType();
        if (type == null) {
            type = this.ctx.getIBeanDefaultConfig().getReturnType();
        }
        return type;
    }

    public Object ibeanUriParam(String name) {
        return this.ctx.getIBeanConfig().getUriParams().get(name);
    }

    public Object ibeanHeaderParam(String name) {
        return this.ctx.getIBeanConfig().getHeaderParams().get(name);
    }

    public Object ibeanPropertyParam(String name) {
        return this.ctx.getIBeanConfig().getPropertyParams().get(name);
    }

    public Object ibeanPayloadParam(String name) {
        return this.ctx.getIBeanConfig().getPayloadParams().get(name);
    }

    public List<Object> ibeanPayloads() {
        return this.ctx.getIBeanConfig().getPayloads();
    }

    public Set<DataSource> ibeanAttachments() {
        return this.ctx.getIBeanConfig().getAttachments();
    }

    public void ibeanSetMessageCallback(MockMessageCallback callback) {
        this.callback = callback;
    }
}

