/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.spi.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.DynamicURIInboundEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.transport.AbstractConnector;
import org.mule.transport.service.TransportFactory;
import org.mule.util.BeanUtils;
import org.mule.util.TemplateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicRequestEndpoint
extends DynamicURIInboundEndpoint {
    public static final String EVAL_PARAM_PROPERTY = "eval.param";
    protected final transient Log logger = LogFactory.getLog(DynamicRequestEndpoint.class);
    private static final long serialVersionUID = 8861985949279708638L;
    protected String uri;
    protected AbstractConnector localConnector;
    protected TemplateParser parser = TemplateParser.createCurlyBracesStyleParser();

    public DynamicRequestEndpoint(InboundEndpoint endpoint, String uri) {
        super(endpoint);
        this.uri = uri;
        this.localConnector = (AbstractConnector)endpoint.getConnector();
    }

    protected Map<String, Object> getPropertiesForTemplate(MuleMessage message) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(this.getProperties());
        for (String propertyKey : message.getOutboundPropertyNames()) {
            props.put(propertyKey, message.getOutboundProperty(propertyKey));
        }
        return props;
    }

    protected EndpointURI getEndpointURIForMessage(MuleMessage message) throws MessagingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri before parsing is: " + this.uri));
        }
        Map<String, Object> props = this.getPropertiesForTemplate(message);
        String newUriString = this.parser.parse(props, this.uri);
        Object evalParam = props.get(EVAL_PARAM_PROPERTY);
        newUriString = evalParam != null ? this.getMuleContext().getExpressionManager().parse(newUriString, (MuleMessage)new DefaultMuleMessage(evalParam, this.getMuleContext()), true) : this.getMuleContext().getExpressionManager().parse(newUriString, message, true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri after parsing is: " + newUriString));
        }
        try {
            this.setEndpointURI((EndpointURI)new MuleEndpointURI(newUriString, this.getMuleContext()));
            if (!this.getLocalConnector().supportsProtocol(this.getEndpointURI().getScheme())) {
                throw new MessagingException(CoreMessages.schemeCannotChangeForRouter((String)this.getEndpointURI().getScheme(), (String)this.getEndpointURI().getScheme()), message);
            }
            this.getEndpointURI().initialise();
            return this.getEndpointURI();
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.templateCausedMalformedEndpoint((String)this.uri, (String)newUriString), message, (Throwable)e);
        }
    }

    public Connector getConnector() {
        try {
            return this.getLocalConnector();
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(e.getI18nMessage(), (Throwable)e);
        }
    }

    protected AbstractConnector getLocalConnector() throws MuleException {
        if (this.localConnector == null) {
            this.localConnector = (AbstractConnector)new TransportFactory(this.getMuleContext()).createConnector(this.getEndpointURI());
            this.getMuleContext().getRegistry().registerConnector((Connector)this.localConnector);
            BeanUtils.populateWithoutFail((Object)this.localConnector, (Map)this.getProperties(), (boolean)false);
        }
        return this.localConnector;
    }

    public MuleMessage request(long timeout, MuleMessage message) throws Exception {
        EndpointURI uri = this.getEndpointURIForMessage(message);
        DynamicURIInboundEndpoint inboundEndpoint = new DynamicURIInboundEndpoint((InboundEndpoint)this, uri);
        if (message.getInvocationProperty("MULE_CREDENTIALS") != null) {
            inboundEndpoint.getProperties().put("MULE_CREDENTIALS", message.getInvocationProperty("MULE_CREDENTIALS"));
        }
        return this.getLocalConnector().request((InboundEndpoint)inboundEndpoint, timeout);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DynamicRequestEndpoint that = (DynamicRequestEndpoint)((Object)o);
        return !(this.uri == null ? that.uri != null : !this.uri.equals(that.uri));
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return result;
    }
}

