/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.HashMap;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.EndpointMessageNotificationListener;
import org.mule.api.context.notification.SecurityNotificationListener;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.service.Service;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.context.notification.SecurityNotification;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.SecurityFilterMessageProcessorBuilder;
import org.mule.message.DefaultExceptionPayload;
import org.mule.routing.MessageFilter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.NullPayload;
import org.mule.util.concurrent.Latch;

public abstract class AbstractMessageProcessorTestCase
extends AbstractMuleTestCase {
    protected static final String TEST_URI = "test://myTestUri";
    protected static String RESPONSE_MESSAGE = "response-message";
    protected static MuleMessage responseMessage;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        responseMessage = this.createTestResponseMuleMessage();
        muleContext.start();
    }

    protected void configureMuleContext(MuleContextBuilder builder) {
        super.configureMuleContext(builder);
        ServerNotificationManager notificationManager = new ServerNotificationManager();
        notificationManager.addInterfaceToType(EndpointMessageNotificationListener.class, EndpointMessageNotification.class);
        notificationManager.addInterfaceToType(SecurityNotificationListener.class, SecurityNotification.class);
        builder.setNotificationManager(notificationManager);
    }

    protected InboundEndpoint createTestInboundEndpoint(Transformer transformer, Transformer responseTransformer) throws EndpointException, InitialisationException {
        return this.createTestInboundEndpoint(null, null, transformer, responseTransformer, MessageExchangePattern.REQUEST_RESPONSE, null);
    }

    protected InboundEndpoint createTestInboundEndpoint(Filter filter, EndpointSecurityFilter securityFilter, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws InitialisationException, EndpointException {
        return this.createTestInboundEndpoint(filter, securityFilter, null, null, exchangePattern, txConfig);
    }

    protected InboundEndpoint createTestInboundEndpoint(Filter filter, EndpointSecurityFilter securityFilter, Transformer transformer, Transformer responseTransformer, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws EndpointException, InitialisationException {
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(TEST_URI, muleContext);
        endpointBuilder.addMessageProcessor((MessageProcessor)new MessageFilter(filter));
        endpointBuilder.addMessageProcessor((MessageProcessor)new SecurityFilterMessageProcessorBuilder(securityFilter));
        if (transformer != null) {
            endpointBuilder.setTransformers(Collections.singletonList((Object)transformer));
        }
        if (responseTransformer != null) {
            endpointBuilder.setResponseTransformers(Collections.singletonList((Object)responseTransformer));
        }
        endpointBuilder.setExchangePattern(exchangePattern);
        endpointBuilder.setTransactionConfig(txConfig);
        InboundEndpoint endpoint = endpointBuilder.buildInboundEndpoint();
        return endpoint;
    }

    protected MuleEvent createTestInboundEvent(InboundEndpoint endpoint) throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "value1");
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"Test Message", props, muleContext), (ImmutableEndpoint)endpoint, AbstractMessageProcessorTestCase.getTestSession(AbstractMessageProcessorTestCase.getTestService(), muleContext));
    }

    protected OutboundEndpoint createTestOutboundEndpoint(Transformer transformer, Transformer responseTransformer) throws EndpointException, InitialisationException {
        return this.createTestOutboundEndpoint(null, null, transformer, responseTransformer, MessageExchangePattern.REQUEST_RESPONSE, null);
    }

    protected OutboundEndpoint createTestOutboundEndpoint(Filter filter, EndpointSecurityFilter securityFilter, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws InitialisationException, EndpointException {
        return this.createTestOutboundEndpoint(filter, securityFilter, null, null, exchangePattern, txConfig);
    }

    protected OutboundEndpoint createTestOutboundEndpoint(Filter filter, EndpointSecurityFilter securityFilter, Transformer transformer, Transformer responseTransformer, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws EndpointException, InitialisationException {
        return this.createTestOutboundEndpoint("test://test", filter, securityFilter, transformer, responseTransformer, exchangePattern, txConfig);
    }

    protected OutboundEndpoint createTestOutboundEndpoint(String uri, Filter filter, EndpointSecurityFilter securityFilter, Transformer transformer, Transformer responseTransformer, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws EndpointException, InitialisationException {
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(uri, muleContext);
        endpointBuilder.addMessageProcessor((MessageProcessor)new MessageFilter(filter));
        endpointBuilder.addMessageProcessor((MessageProcessor)new SecurityFilterMessageProcessorBuilder(securityFilter));
        if (transformer != null) {
            endpointBuilder.setMessageProcessors(Collections.singletonList((Object)transformer));
        }
        if (responseTransformer != null) {
            endpointBuilder.setResponseMessageProcessors(Collections.singletonList((Object)responseTransformer));
        }
        endpointBuilder.setExchangePattern(exchangePattern);
        endpointBuilder.setTransactionConfig(txConfig);
        this.customizeEndpointBuilder((EndpointBuilder)endpointBuilder);
        return endpointBuilder.buildOutboundEndpoint();
    }

    protected void customizeEndpointBuilder(EndpointBuilder endpointBuilder) {
    }

    protected MuleEvent createTestOutboundEvent(OutboundEndpoint endpoint) throws Exception {
        return this.createTestOutboundEvent(endpoint, null);
    }

    protected MuleEvent createTestOutboundEvent(OutboundEndpoint endpoint, MessagingExceptionHandler exceptionListener) throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("prop1", "value1");
        props.put("port", new Integer(12345));
        Service svc = AbstractMessageProcessorTestCase.getTestService();
        if (exceptionListener != null) {
            svc.setExceptionListener(exceptionListener);
        }
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"Test Message", props, muleContext), (ImmutableEndpoint)endpoint, AbstractMessageProcessorTestCase.getTestSession(svc, muleContext));
    }

    protected MuleMessage createTestResponseMuleMessage() {
        return new DefaultMuleMessage((Object)RESPONSE_MESSAGE, muleContext);
    }

    public static class TestExceptionListener
    implements MessagingExceptionHandler {
        public Exception sensedException;

        public MuleEvent handleException(Exception exception, MuleEvent event) {
            this.sensedException = exception;
            event.getMessage().setPayload((Object)NullPayload.getInstance());
            event.getMessage().setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)exception));
            return event;
        }
    }

    public static class ExceptionThrowingMessageProcessr
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            throw new IllegalStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestEndpointMessageNotificationListener
    implements EndpointMessageNotificationListener<EndpointMessageNotification> {
        public EndpointMessageNotification messageNotification;
        public Latch latch = new Latch();

        public void onNotification(EndpointMessageNotification notification) {
            this.messageNotification = notification;
            this.latch.countDown();
        }
    }

    public static class TestListener
    implements MessageProcessor {
        public MuleEvent sensedEvent;

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.sensedEvent = event;
            return event;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestSecurityNotificationListener
    implements SecurityNotificationListener<SecurityNotification> {
        public SecurityNotification securityNotification;
        public Latch latch = new Latch();

        public void onNotification(SecurityNotification notification) {
            this.securityNotification = notification;
            this.latch.countDown();
        }
    }

    public static class TestFilter
    implements Filter {
        public boolean accept;

        public TestFilter(boolean accept) {
            this.accept = accept;
        }

        public boolean accept(MuleMessage message) {
            return this.accept;
        }
    }
}

