/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.List;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.ArrayUtils;
import org.mule.util.StringUtils;

public class ArrayUtilsTestCase
extends AbstractMuleTestCase {
    public void testToArrayOfComponentType() {
        ArrayUtilsTestCase.assertNull((Object)ArrayUtils.toArrayOfComponentType(null, String.class));
        Object[] a = new String[]{};
        String[] a2 = (String[])ArrayUtils.toArrayOfComponentType((Object[])a, String.class);
        ArrayUtilsTestCase.assertSame((Object)a2, (Object)a);
        try {
            ArrayUtils.toArrayOfComponentType((Object[])a, null);
            ArrayUtilsTestCase.fail();
        }
        catch (IllegalArgumentException iex) {
            // empty catch block
        }
        a = new String[]{":-)"};
        CharSequence[] cs = (CharSequence[])ArrayUtils.toArrayOfComponentType((Object[])a, CharSequence.class);
        ArrayUtilsTestCase.assertEquals((int)a.length, (int)cs.length);
        ArrayUtilsTestCase.assertSame((Object)a[0], (Object)cs[0]);
        try {
            ArrayUtils.toArrayOfComponentType((Object[])a, List.class);
            ArrayUtilsTestCase.fail();
        }
        catch (ArrayStoreException asx) {
            // empty catch block
        }
    }

    public void testToStringMaxLength() {
        byte[] test = new byte[100];
        for (int i = 0; i < test.length; ++i) {
            test[i] = (byte)i;
        }
        String result = ArrayUtils.toString((Object)test, (int)10);
        ArrayUtilsTestCase.assertTrue((boolean)result.endsWith("[..]}"));
        ArrayUtilsTestCase.assertEquals((int)9, (int)StringUtils.countMatches((String)result, (String)","));
    }
}

