/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.jpdl.internal.activity.JpdlActivity;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.model.Activity;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinActivity
extends JpdlActivity {
    private static final long serialVersionUID = 1L;
    int multiplicity = -1;
    LockMode lockMode = LockMode.UPGRADE;

    public void execute(ActivityExecution execution) {
        this.execute((ExecutionImpl)execution);
    }

    public void execute(ExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        if ("active-root".equals(execution.getState())) {
            Transition transition = activity.getDefaultOutgoingTransition();
            if (transition == null) {
                throw new JbpmException("join must have an outgoing transition");
            }
            execution.take(transition);
        } else if ("active-concurrent".equals(execution.getState())) {
            Session session = (Session)EnvironmentImpl.getFromCurrent(Session.class);
            session.lock((Object)execution.getParent(), this.lockMode);
            execution.setState("inactive-join");
            execution.waitForSignal();
            ExecutionImpl concurrentRoot = execution.getParent();
            List<ExecutionImpl> joinedExecutions = this.getJoinedExecutions(concurrentRoot, (Activity)activity);
            if (this.isComplete(joinedExecutions, (Activity)activity)) {
                this.endJoinedExecutions(joinedExecutions);
                ExecutionImpl outgoingExecution = null;
                if (concurrentRoot.getExecutions().size() == 0) {
                    outgoingExecution = concurrentRoot;
                    outgoingExecution.setState("active-root");
                } else {
                    outgoingExecution = concurrentRoot.createExecution();
                    outgoingExecution.setState("active-concurrent");
                }
                execution.setActivity((Activity)activity, (Execution)outgoingExecution);
                Transition transition = activity.getDefaultOutgoingTransition();
                if (transition == null) {
                    throw new JbpmException("join must have an outgoing transition");
                }
                outgoingExecution.take(transition);
            }
        } else {
            throw new JbpmException("invalid execution state");
        }
    }

    protected boolean isComplete(List<ExecutionImpl> joinedExecutions, Activity activity) {
        int nbrOfExecutionsToJoin = this.multiplicity;
        if (this.multiplicity == -1) {
            nbrOfExecutionsToJoin = activity.getIncomingTransitions().size();
        }
        return joinedExecutions.size() == nbrOfExecutionsToJoin;
    }

    protected List<ExecutionImpl> getJoinedExecutions(ExecutionImpl concurrentRoot, Activity activity) {
        ArrayList<ExecutionImpl> joinedExecutions = new ArrayList<ExecutionImpl>();
        List concurrentExecutions = (List)concurrentRoot.getExecutions();
        for (ExecutionImpl concurrentExecution : concurrentExecutions) {
            if (!"inactive-join".equals(concurrentExecution.getState()) || concurrentExecution.getActivity() != activity) continue;
            joinedExecutions.add(concurrentExecution);
        }
        return joinedExecutions;
    }

    protected void endJoinedExecutions(List<ExecutionImpl> joinedExecutions) {
        for (ExecutionImpl joinedExecution : joinedExecutions) {
            joinedExecution.end();
        }
    }

    public void setMultiplicity(int multiplicity) {
        this.multiplicity = multiplicity;
    }

    public void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
    }
}

