/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.io;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.PGPInvalidChecksumException;
import cryptix.openpgp.io.PGPDataInputStream;
import java.io.IOException;

public class PGPChecksumDataInputStream
extends PGPDataInputStream {
    private PGPDataInputStream in;
    private int checksum = 0;

    public PGPChecksumDataInputStream(PGPDataInputStream in) {
        this.in = in;
    }

    public void close() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        int c = this.in.readUnsignedShort();
        if (c != this.checksum) {
            throw new PGPInvalidChecksumException("Read: " + c + " Found: " + this.checksum);
        }
    }

    protected int readInternal() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        short b = this.in.readUnsignedByte();
        this.checksum += b;
        return b;
    }
}

