/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.packet;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class PGPCryptHelper {
    private PGPCryptHelper() {
    }

    static byte[] crypt(boolean encrypt, Cipher cp, byte[] iv, byte[] key, byte[] data) {
        byte[] result;
        StringTokenizer st = new StringTokenizer(cp.getAlgorithm(), "/");
        SecretKeySpec sk = new SecretKeySpec(key, st.nextToken());
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        try {
            if (encrypt) {
                cp.init(1, (Key)sk, ivspec);
            } else {
                cp.init(2, (Key)sk, ivspec);
            }
        }
        catch (InvalidKeyException ike) {
            throw new InternalError("InvalidKeyException on de/encrypting a key - " + ike);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InternalError("InvalidAlgorithmParameterException on de/encrypting a key - " + iape);
        }
        try {
            result = cp.doFinal(data);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new RuntimeException("IllegalBlockSizeException on de/encrypting a key - " + ibse);
        }
        catch (BadPaddingException bpe) {
            throw new InternalError("BadPaddingException on de/encrypting a key - " + bpe);
        }
        return result;
    }
}

