/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.packet;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPSigner;
import cryptix.openpgp.io.PGPByteArrayDataInputStream;
import cryptix.openpgp.io.PGPByteArrayDataOutputStream;
import cryptix.openpgp.io.PGPPacketDataInputStream;
import cryptix.openpgp.io.PGPPacketDataOutputStream;
import cryptix.openpgp.packet.PGPPacket;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.signature.PGPSignatureSubPacketFactory;
import cryptix.openpgp.util.PGPCompare;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Vector;

public class PGPSignaturePacket
extends PGPPacket {
    private byte type;
    private byte algoid;
    private byte hashid;
    private byte version;
    private byte[] sigdata;
    private byte[] hashval;
    private byte[] time;
    private byte[] keyid;
    private byte[] hashedbytes;
    private byte[] unhashedbytes;
    private Vector hashed;
    private Vector unhashed;

    public void decodeBody(PGPPacketDataInputStream in, PGPAlgorithmFactory factory) throws IOException, PGPFatalDataFormatException, PGPDataFormatException {
        this.version = in.readByte();
        if (this.version == 3) {
            byte temp = in.readByte();
            if (temp != 5) {
                throw new RuntimeException("There should be 5 bytes of hashed  material");
            }
            this.type = in.readByte();
            this.time = new byte[4];
            int i = 0;
            while (i < 4) {
                this.time[i] = in.readByte();
                ++i;
            }
            this.keyid = new byte[8];
            int i2 = 0;
            while (i2 < 8) {
                this.keyid[i2] = in.readByte();
                ++i2;
            }
            this.algoid = in.readByte();
            this.hashid = in.readByte();
            this.hashval = new byte[2];
            int i3 = 0;
            while (i3 < 2) {
                this.hashval[i3] = in.readByte();
                ++i3;
            }
            this.sigdata = in.readByteArray();
        } else if (this.version == 4) {
            this.type = in.readByte();
            this.algoid = in.readByte();
            this.hashid = in.readByte();
            int len = in.readUnsignedShort();
            this.hashedbytes = new byte[len];
            in.readFully(this.hashedbytes);
            len = in.readUnsignedShort();
            this.unhashedbytes = new byte[len];
            in.readFully(this.unhashedbytes);
            this.hashval = new byte[2];
            int i = 0;
            while (i < 2) {
                this.hashval[i] = in.readByte();
                ++i;
            }
            this.sigdata = in.readByteArray();
        } else {
            in.readByteArray();
            throw new PGPDataFormatException("Unsupported version (" + this.version + ") for signatures.");
        }
    }

    public void encodeBody(PGPPacketDataOutputStream out) throws IOException {
        if (this.version == 4) {
            out.writeByte((byte)4);
            out.writeByte(this.type);
            out.writeByte(this.algoid);
            out.writeByte(this.hashid);
            out.writeShort((short)this.hashedbytes.length);
            out.writeFully(this.hashedbytes);
            out.writeShort((short)this.unhashedbytes.length);
            out.writeFully(this.unhashedbytes);
            int i = 0;
            while (i < 2) {
                out.writeByte(this.hashval[i]);
                ++i;
            }
            out.writeFully(this.sigdata);
        } else {
            out.writeByte((byte)3);
            out.writeByte((byte)5);
            out.writeByte(this.type);
            int i = 0;
            while (i < 4) {
                out.writeByte(this.time[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < 8) {
                out.writeByte(this.keyid[i2]);
                ++i2;
            }
            out.writeByte(this.algoid);
            out.writeByte(this.hashid);
            int i3 = 0;
            while (i3 < 2) {
                out.writeByte(this.hashval[i3]);
                ++i3;
            }
            out.writeFully(this.sigdata);
        }
    }

    public boolean equals(Object ssp) {
        if (ssp instanceof PGPSignaturePacket) {
            boolean equal;
            PGPSignaturePacket that = (PGPSignaturePacket)ssp;
            boolean bl = equal = PGPCompare.equals(this.type, that.type) && PGPCompare.equals(this.algoid, that.algoid) && PGPCompare.equals(this.hashid, that.hashid) && PGPCompare.equals(this.version, that.version) && PGPCompare.equals(this.sigdata, that.sigdata) && PGPCompare.equals(this.hashval, that.hashval);
            equal = this.version == 3 ? equal && PGPCompare.equals(this.time, that.time) && PGPCompare.equals(this.keyid, that.keyid) : equal && PGPCompare.equals(this.hashedbytes, that.hashedbytes) && PGPCompare.equals(this.unhashedbytes, that.unhashedbytes);
            return equal;
        }
        return false;
    }

    public byte getAlgoID() {
        return this.algoid;
    }

    public Vector getAllSubPackets() {
        if (this.hashed == null) {
            throw new IllegalStateException("Call parseSignatureSubPackets first");
        }
        if (this.unhashed == null) {
            throw new IllegalStateException("Call parseSignatureSubPackets first");
        }
        Vector x = new Vector(this.hashed.size() + this.unhashed.size());
        int i = 0;
        while (i < this.hashed.size()) {
            x.addElement(this.hashed.elementAt(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.unhashed.size()) {
            x.addElement(this.unhashed.elementAt(i2));
            ++i2;
        }
        return x;
    }

    public int getForceLengthType() {
        if (this.version <= 3) {
            return 1;
        }
        return -1;
    }

    public byte[] getHash() {
        return this.hashval;
    }

    public byte getHashID() {
        return this.hashid;
    }

    public Vector getHashedSubPackets() {
        if (this.hashed == null) {
            throw new IllegalStateException("Call parseSignatureSubPackets first");
        }
        return this.hashed;
    }

    public byte[] getKeyID() {
        return this.keyid;
    }

    public byte[] getTime() {
        return this.time;
    }

    public byte getType() {
        return this.type;
    }

    public Vector getUnhashedSubPackets() {
        if (this.unhashed == null) {
            throw new IllegalStateException("Call parseSignatureSubPackets first");
        }
        return this.unhashed;
    }

    public byte getVersion() {
        return this.version;
    }

    public int hashData(MessageDigest md, PGPSigner signer) {
        if (this.version == 4) {
            byte[] pre = new byte[]{this.version, this.type, this.algoid, this.hashid, (byte)(this.hashedbytes.length >> 8 & 0xFF), (byte)(this.hashedbytes.length & 0xFF)};
            md.update(pre);
            signer.update(pre);
            md.update(this.hashedbytes);
            signer.update(this.hashedbytes);
            return pre.length + this.hashedbytes.length;
        }
        if (this.version == 3) {
            byte[] typebytes = new byte[]{this.type};
            md.update(typebytes);
            signer.update(typebytes);
            md.update(this.time);
            signer.update(this.time);
            return 5;
        }
        throw new IllegalStateException("Version should be 3 or 4");
    }

    public void interpretSignature(PGPSigner signer) throws IOException, PGPDataFormatException {
        PGPByteArrayDataInputStream badis = new PGPByteArrayDataInputStream(this.sigdata);
        try {
            signer.decodeSignatureData(badis);
            badis.close();
        }
        catch (PGPFatalDataFormatException pGPFatalDataFormatException) {
            throw new InternalError("PGPByteArrayDataInputStream should not throw a PGPFatalDataFormatException.");
        }
    }

    public void parseSignatureSubPackets() throws PGPDataFormatException, PGPFatalDataFormatException {
        this.parseSignatureSubPackets(PGPSignatureSubPacketFactory.getDefaultInstance());
    }

    public void parseSignatureSubPackets(PGPSignatureSubPacketFactory factory) throws PGPDataFormatException, PGPFatalDataFormatException {
        if (this.version == 3) {
            throw new IllegalStateException("Version 3 signatures have no SignatureSubPackets.");
        }
        try {
            PGPSignatureSubPacket ssp;
            this.hashed = new Vector();
            this.unhashed = new Vector();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.hashedbytes);
            while (bais.available() > 0) {
                ssp = factory.readPacket(bais);
                this.hashed.addElement(ssp);
            }
            bais = new ByteArrayInputStream(this.unhashedbytes);
            while (bais.available() > 0) {
                ssp = factory.readPacket(bais);
                this.unhashed.addElement(ssp);
            }
        }
        catch (IOException iOException) {
            throw new InternalError("PANIC: IOEx. on ByteArrayInputStream");
        }
    }

    public void setData(byte type, byte algoid, byte hashid, Vector hashed, Vector unhashed) {
        this.version = (byte)4;
        this.type = type;
        this.algoid = algoid;
        this.hashid = hashid;
        this.hashed = hashed;
        this.unhashed = unhashed;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int i = 0;
            while (i < hashed.size()) {
                ((PGPSignatureSubPacket)hashed.elementAt(i)).encode(baos);
                ++i;
            }
            this.hashedbytes = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            int i2 = 0;
            while (i2 < unhashed.size()) {
                ((PGPSignatureSubPacket)unhashed.elementAt(i2)).encode(baos);
                ++i2;
            }
            this.unhashedbytes = baos.toByteArray();
        }
        catch (IOException iOException) {
            throw new InternalError("IOException in ByteArrayOutputStream");
        }
    }

    public void setData(byte type, byte[] time, byte[] keyid, byte algoid, byte hashid) {
        this.version = (byte)3;
        this.type = type;
        this.time = time;
        this.keyid = keyid;
        this.algoid = algoid;
        this.hashid = hashid;
    }

    public void setHash(byte[] hashval) {
        this.hashval = new byte[2];
        this.hashval[0] = hashval[0];
        this.hashval[1] = hashval[1];
    }

    public void setHashedSubPackets(Vector x) {
        this.hashed = x;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int i = 0;
            while (i < this.hashed.size()) {
                ((PGPSignatureSubPacket)this.hashed.elementAt(i)).encode(baos);
                ++i;
            }
        }
        catch (IOException ioe) {
            throw new InternalError("IOException on encoding signature subpackets - " + ioe);
        }
        this.hashedbytes = baos.toByteArray();
        if (this.hashedbytes.length > 65535) {
            throw new IllegalArgumentException("Encoded signature subpackets too large (> 65535 bytes)");
        }
    }

    public void setSignature(PGPSigner signer) {
        try {
            PGPByteArrayDataOutputStream bados = new PGPByteArrayDataOutputStream();
            signer.encodeSignatureData(bados);
            bados.close();
            this.sigdata = bados.toByteArray();
        }
        catch (IOException iOException) {
            throw new InternalError("IOException in ByteArrayOutputStream");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Signer did not contains asignature.");
        }
    }

    public void setUnhashedSubPackets(Vector x) {
        this.unhashed = x;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int i = 0;
            while (i < this.unhashed.size()) {
                ((PGPSignatureSubPacket)this.unhashed.elementAt(i)).encode(baos);
                ++i;
            }
        }
        catch (IOException ioe) {
            throw new InternalError("IOException on encoding signature subpackets - " + ioe);
        }
        this.unhashedbytes = baos.toByteArray();
        if (this.unhashedbytes.length > 65535) {
            throw new IllegalArgumentException("Encoded signature subpackets too large (> 65535 bytes)");
        }
    }
}

