/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.signature;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPSignatureDataInputStream;
import cryptix.openpgp.io.PGPSignatureDataOutputStream;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class PGPNotationDataSP
extends PGPSignatureSubPacket {
    private byte[] flags;
    private String namedata;
    private String valuedata;

    protected void decodeBody(PGPSignatureDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        byte[] flags = new byte[4];
        in.readFully(flags);
        this.setFlags(flags);
        int m = in.readUnsignedShort();
        int n = in.readUnsignedShort();
        if (m == 0 || n == 0) {
            in.readByteArray();
            throw new PGPDataFormatException("String length == 0.");
        }
        byte[] namebytes = new byte[m];
        byte[] valuebytes = new byte[n];
        in.readFully(namebytes);
        in.readFully(valuebytes);
        try {
            this.setNameData(new String(namebytes, "UTF-8"));
            this.setValueData(new String(valuebytes, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Unsupported encoding: UTF-8");
        }
    }

    protected void encodeBody(PGPSignatureDataOutputStream out) throws IOException {
        if (this.namedata == null || this.valuedata == null || this.flags == null) {
            throw new IllegalStateException("Packet data not initialized");
        }
        out.writeFully(this.getFlags());
        try {
            byte[] namebytes = this.namedata.getBytes("UTF-8");
            byte[] valuebytes = this.valuedata.getBytes("UTF-8");
            out.writeShort((short)namebytes.length);
            out.writeShort((short)valuebytes.length);
            out.writeFully(namebytes);
            out.writeFully(valuebytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Unsupported encoding: UTF-8");
        }
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPNotationDataSP)) {
            return false;
        }
        PGPNotationDataSP that = (PGPNotationDataSP)ssp;
        return PGPCompare.equals(this.getPacketID(), that.getPacketID()) && PGPCompare.equals(this.getFlags(), that.getFlags()) && PGPCompare.equals(this.getNameData(), that.getNameData()) && PGPCompare.equals(this.getValueData(), that.getValueData());
    }

    public byte[] getFlags() {
        if (this.flags == null) {
            this.flags = new byte[4];
            this.flags[3] = 0;
            this.flags[2] = 0;
            this.flags[1] = 0;
            this.flags[0] = 0;
        }
        return this.flags;
    }

    public boolean getHumanReadable() {
        if (this.flags == null) {
            this.flags = new byte[4];
            this.flags[3] = 0;
            this.flags[2] = 0;
            this.flags[1] = 0;
            this.flags[0] = 0;
        }
        return (this.flags[0] & 0x80) != 0;
    }

    public String getNameData() {
        return this.namedata;
    }

    public String getValueData() {
        return this.valuedata;
    }

    public void setFlags(byte[] flags) {
        if (flags.length != 4) {
            throw new IllegalArgumentException("Flags should be 4 bytes");
        }
        this.flags = flags;
    }

    public void setHumanReadable(boolean flag) {
        if (this.flags == null) {
            this.flags = new byte[4];
            this.flags[3] = 0;
            this.flags[2] = 0;
            this.flags[1] = 0;
            this.flags[0] = 0;
        }
        this.flags[0] = flag ? (byte)(this.flags[0] | 0x80) : (byte)(this.flags[0] & 0x7F);
    }

    public void setNameData(String namedata) {
        if (namedata.length() == 0) {
            throw new IllegalArgumentException("String length == 0");
        }
        this.namedata = namedata;
    }

    public void setValueData(String valuedata) {
        if (valuedata.length() == 0) {
            throw new IllegalArgumentException("String length == 0");
        }
        this.valuedata = valuedata;
    }
}

