/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.jetty;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.NoReceiverForEndpointException;
import org.mule.transport.http.HttpMessageReceiver;
import org.mule.transport.servlet.MuleReceiverServlet;
import org.mule.util.StringUtils;

public class JettyReceiverServlet
extends MuleReceiverServlet {
    private static final long serialVersionUID = 238326861089137293L;
    private ConcurrentMap receivers = new ConcurrentHashMap(4);

    protected MessageReceiver getReceiverForURI(HttpServletRequest httpServletRequest) throws EndpointException {
        MessageReceiver receiver;
        String key = httpServletRequest.getPathInfo();
        if ("".equals(key)) {
            key = httpServletRequest.getContextPath();
        }
        if ((receiver = (MessageReceiver)this.receivers.get((Object)key)) == null) {
            receiver = HttpMessageReceiver.findReceiverByStem((Map)this.receivers, (String)key);
        }
        if (receiver == null) {
            throw new NoReceiverForEndpointException(httpServletRequest.getPathInfo());
        }
        return receiver;
    }

    void addReceiver(MessageReceiver receiver) {
        this.receivers.putIfAbsent((Object)this.getReceiverKey(receiver), (Object)receiver);
    }

    boolean removeReceiver(MessageReceiver receiver) {
        return this.receivers.remove((Object)this.getReceiverKey(receiver), (Object)receiver);
    }

    protected String getReceiverKey(MessageReceiver receiver) {
        String key = receiver.getEndpoint().getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)key)) {
            key = "/";
        }
        return key;
    }
}

