/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cfg;

import java.io.IOException;
import org.jbpm.api.ProcessEngine;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cfg.ProcessEngineImpl;
import org.jbpm.pvm.internal.env.EnvironmentFactory;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.env.PvmEnvironment;
import org.jbpm.pvm.internal.env.SpringContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringConfiguration
extends ProcessEngineImpl
implements EnvironmentFactory,
ProcessEngine,
ApplicationContextAware {
    private static final Log log = Log.getLog((String)SpringConfiguration.class.getName());
    private static final long serialVersionUID = 1L;
    private ApplicationContext applicationContext;
    private String jbpmConfigurationLocation;

    public SpringConfiguration(String jbpmConfigurationLocation) {
        try {
            super.setInputStream(new ClassPathResource(jbpmConfigurationLocation).getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SpringConfiguration() {
    }

    @Override
    public ProcessEngine buildProcessEngine() {
        if (this.applicationContext == null) {
            this.applicationContext = new ClassPathXmlApplicationContext(System.getProperty("jbpm.test.cfg.applicationContext"));
        }
        return super.buildProcessEngine();
    }

    @Override
    public EnvironmentImpl openEnvironment() {
        PvmEnvironment environment = new PvmEnvironment(this);
        if (log.isTraceEnabled()) {
            log.trace("opening jbpm-spring" + environment);
        }
        environment.setContext(new SpringContext(this.applicationContext));
        this.installAuthenticatedUserId(environment);
        this.installProcessEngineContext(environment);
        this.installTransactionContext(environment);
        return environment;
    }

    @Override
    public <T> T get(Class<T> type) {
        String[] names = this.applicationContext.getBeanNamesForType(type);
        if (names.length == 1) {
            return (T)this.applicationContext.getBean(names[0]);
        }
        return super.get(type);
    }

    @Override
    public Object get(String key) {
        if (this.applicationContext.containsBean(key)) {
            return this.applicationContext.getBean(key);
        }
        return super.get(key);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

