/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.history.events;

import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.model.HistoryProcessInstanceImpl;
import org.jbpm.pvm.internal.history.model.HistoryTaskImpl;
import org.jbpm.pvm.internal.history.model.HistoryTaskInstanceImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.TaskImpl;

public class TaskActivityStart
extends HistoryEvent {
    private static final long serialVersionUID = 1L;
    protected TaskImpl task;

    public TaskActivityStart(TaskImpl task) {
        this.task = task;
    }

    public void process() {
        DbSession dbSession = EnvironmentImpl.getFromCurrent(DbSession.class);
        ExecutionImpl processInstance = this.execution.getProcessInstance();
        long processInstanceDbid = processInstance.getDbid();
        HistoryProcessInstance historyProcessInstance = dbSession.get(HistoryProcessInstanceImpl.class, processInstanceDbid);
        HistoryTaskImpl historyTask = new HistoryTaskImpl(this.task);
        historyTask.setExecutionId(this.execution.getId());
        HistoryTaskInstanceImpl historyActivityInstance = new HistoryTaskInstanceImpl(historyProcessInstance, this.execution, historyTask);
        String activityType = this.execution.getActivity().getType();
        historyActivityInstance.setType(activityType);
        dbSession.save(historyActivityInstance);
        this.execution.setHistoryActivityInstanceDbid(historyActivityInstance.getDbid());
    }
}

