/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import java.util.Collection;
import java.util.Date;
import org.jbpm.api.cmd.Command;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;
import org.jbpm.pvm.internal.jobexecutor.JobParcel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatcherThread
extends Thread {
    private static final Log log = Log.getLog((String)DispatcherThread.class.getName());
    protected JobExecutor jobExecutor;
    protected volatile boolean isActive = true;
    protected boolean checkForNewJobs;
    protected int currentIdleInterval;
    protected Object semaphore = new Object();

    protected DispatcherThread(JobExecutor jobExecutor) {
        this(jobExecutor, "DispatcherThread");
    }

    protected DispatcherThread(JobExecutor jobExecutor, String name) {
        super(name);
        this.jobExecutor = jobExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block21: {
            log.info("starting " + this.getName());
            this.currentIdleInterval = this.jobExecutor.getIdleMillis();
            block14: while (true) {
                while (this.isActive) {
                    try {
                        long waitPeriod;
                        this.checkForNewJobs = false;
                        Collection<Long> acquiredJobDbids = this.acquireJobs();
                        this.currentIdleInterval = this.jobExecutor.getIdleMillis();
                        if (acquiredJobDbids != null && !acquiredJobDbids.isEmpty()) {
                            this.submitAcquiredJobDbids(acquiredJobDbids);
                            log.debug("added jobs " + acquiredJobDbids + " to the queue");
                            continue block14;
                        }
                        if (!this.isActive || (waitPeriod = this.getWaitPeriod()) <= 0L) continue block14;
                        Object object = this.semaphore;
                        synchronized (object) {
                            if (!this.checkForNewJobs) {
                                log.trace(this.getName() + " will wait for max " + waitPeriod + "ms on " + this.jobExecutor);
                                this.semaphore.wait(waitPeriod);
                                log.trace(this.getName() + " woke up");
                            } else {
                                log.debug("skipped wait because new message arrived");
                            }
                            continue block14;
                        }
                    }
                    catch (InterruptedException e) {
                        log.info((this.isActive ? "active" : "inactive") + " job dispatcher thread '" + this.getName() + "' got interrupted");
                    }
                    catch (Exception e) {
                        if (e.getMessage().indexOf("couldn't lookup 'UserTransaction' from jndi: UserTransaction not bound: UserTransaction not bound") == -1) {
                            log.error("exception in job executor thread. waiting " + this.currentIdleInterval + " milliseconds", (Throwable)e);
                        }
                        try {
                            Object waitPeriod = this.semaphore;
                            synchronized (waitPeriod) {
                                this.semaphore.wait(this.currentIdleInterval);
                            }
                        }
                        catch (InterruptedException e2) {
                            log.trace("delay after exception got interrupted", (Throwable)e2);
                        }
                        this.currentIdleInterval *= 2;
                    }
                }
                break block21;
                {
                    continue block14;
                    break;
                }
                break;
            }
            finally {
                log.info(this.getName() + " leaves cyberspace");
            }
        }
    }

    protected void submitAcquiredJobDbids(Collection<Long> jobDbids) {
        log.debug("submitting jobs " + jobDbids);
        this.jobExecutor.getThreadPool().submit(new JobParcel(this.jobExecutor.getCommandExecutor(), jobDbids));
        log.trace("jobs " + jobDbids + " were submitted");
    }

    protected Collection<Long> acquireJobs() {
        CommandService commandService = this.jobExecutor.getCommandExecutor();
        Command<Collection<Long>> acquireJobsCommand = this.jobExecutor.getAcquireJobsCommand();
        return commandService.execute(acquireJobsCommand);
    }

    protected Date getNextDueDate() {
        CommandService commandService = this.jobExecutor.getCommandExecutor();
        Command<Date> getNextDueDate = this.jobExecutor.getNextDueDateCommand();
        return commandService.execute(getNextDueDate);
    }

    protected long getWaitPeriod() {
        long interval = this.jobExecutor.getIdleMillis();
        Date nextDueDate = this.getNextDueDate();
        if (nextDueDate != null) {
            long currentTimeMillis = System.currentTimeMillis();
            long nextDueDateTime = nextDueDate.getTime();
            if (nextDueDateTime < currentTimeMillis + (long)this.currentIdleInterval) {
                interval = nextDueDateTime - currentTimeMillis;
            }
        }
        if (interval < 0L) {
            interval = 0L;
        }
        return interval;
    }

    public void deactivate() {
        this.deactivate(false);
    }

    public void deactivate(boolean join) {
        if (this.isActive) {
            log.debug("deactivating " + this.getName());
            this.isActive = false;
            this.interrupt();
            if (join) {
                try {
                    log.debug("joining " + this.getName());
                    this.join();
                }
                catch (InterruptedException e) {
                    log.trace("joining " + this.getName() + " got interrupted");
                }
            }
        } else {
            log.trace("ignoring deactivate: " + this.getName() + " is not active");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasAdded() {
        log.trace("notifying job executor dispatcher thread of new job");
        Object object = this.semaphore;
        synchronized (object) {
            this.checkForNewJobs = true;
            this.semaphore.notify();
        }
    }

    public boolean isActive() {
        return this.isActive;
    }
}

