/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import org.jbpm.api.job.Message;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.env.Transaction;
import org.jbpm.pvm.internal.jobexecutor.JobAddedNotification;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.session.MessageSession;
import org.jbpm.pvm.internal.util.ReflectUtil;

public class JobExecutorMessageSession
implements MessageSession {
    private static final Log log = Log.getLog((String)JobExecutorMessageSession.class.getName());
    DbSession dbSession;
    Transaction transaction;
    boolean isNotificationAdded;

    public void send(Message message) {
        log.debug("sending message " + ReflectUtil.getUnqualifiedClassName(message.getClass()));
        this.dbSession.save(message);
        if (!this.isNotificationAdded) {
            this.isNotificationAdded = true;
            JobExecutor jobExecutor = EnvironmentImpl.getCurrent().get(JobExecutor.class);
            if (jobExecutor != null) {
                log.trace("registering job executor notifier with " + this.transaction);
                this.transaction.registerSynchronization(new JobAddedNotification(jobExecutor));
            }
        }
    }
}

