/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.job.Timer;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.Transaction;
import org.jbpm.pvm.internal.job.TimerImpl;
import org.jbpm.pvm.internal.jobexecutor.JobAddedNotification;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;
import org.jbpm.pvm.internal.session.TimerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExecutorTimerSession
implements TimerSession {
    private static final Log log = Log.getLog((String)TimerSession.class.getName());
    Transaction transaction;
    JobExecutor jobExecutor;
    Session session;
    boolean jobExecutorNotificationScheduled = false;

    @Override
    public void schedule(Timer timer) {
        if (timer == null) {
            throw new JbpmException("null timer scheduled");
        }
        if (timer.getExecution() == null) {
            throw new JbpmException("timer has no execution specified");
        }
        if (timer.getSignalName() == null && timer.getEventName() == null) {
            throw new JbpmException("timer has no signalName or eventName specified");
        }
        if (timer.getDueDate() == null) {
            throw new JbpmException("timer scheduled at null date");
        }
        log.debug("scheduling " + timer);
        this.session.save((Object)timer);
        if (!this.jobExecutorNotificationScheduled && this.jobExecutor != null) {
            this.jobExecutorNotificationScheduled = true;
            if (this.transaction != null) {
                this.transaction.registerSynchronization(new JobAddedNotification(this.jobExecutor));
            }
        }
    }

    @Override
    public void cancel(Timer timer) {
        log.debug("canceling " + timer);
        if (timer == null) {
            throw new JbpmException("timer is null");
        }
        this.session.delete((Object)timer);
    }

    @Override
    public List<Timer> findTimersByExecution(Execution execution) {
        Query query = this.session.createQuery("select timer from " + TimerImpl.class.getName() + " timer " + "where timer.execution = :execution");
        query.setEntity("execution", (Object)execution);
        return query.list();
    }
}

