/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.util;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    private XmlUtil() {
    }

    public static List<Element> elements(Element element, String tagName) {
        if (element == null) {
            return Collections.emptyList();
        }
        NodeList activityList = element.getChildNodes();
        if (activityList == null || activityList.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < activityList.getLength(); ++i) {
            Element childElement;
            String childTagName;
            Node child = activityList.item(i);
            if (!Element.class.isAssignableFrom(child.getClass()) || !(childTagName = XmlUtil.getTagLocalName(childElement = (Element)child)).equals(tagName)) continue;
            if (elements == null) {
                elements = new ArrayList();
            }
            elements.add(childElement);
        }
        return elements;
    }

    public static List<Element> elements(Element element, Set<String> allowedTagNames) {
        if (element == null) {
            return Collections.emptyList();
        }
        NodeList activityList = element.getChildNodes();
        if (activityList == null || activityList.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < activityList.getLength(); ++i) {
            Element childElement;
            String childTagName;
            Node child = activityList.item(i);
            if (!Element.class.isAssignableFrom(child.getClass()) || !allowedTagNames.contains(childTagName = XmlUtil.getTagLocalName(childElement = (Element)child))) continue;
            if (elements == null) {
                elements = new ArrayList();
            }
            elements.add(childElement);
        }
        return elements;
    }

    public static Element element(Element element, String tagName) {
        return XmlUtil.element(element, tagName, false, null);
    }

    public static Element element(Element element, String tagName, boolean required, Parse parse) {
        if (element == null) {
            return null;
        }
        NodeList activityList = element.getChildNodes();
        for (int i = 0; i < activityList.getLength(); ++i) {
            Node child = activityList.item(i);
            if (!Element.class.isAssignableFrom(child.getClass()) || !XmlUtil.getTagLocalName((Element)child).equals(tagName)) continue;
            return (Element)child;
        }
        if (required && parse != null) {
            parse.addProblem("nested element <" + XmlUtil.getTagLocalName(element) + "><" + tagName + " ... />... is required", element);
        }
        return null;
    }

    public static List<Element> elements(Element element) {
        if (element == null) {
            return Collections.emptyList();
        }
        NodeList activityList = element.getChildNodes();
        if (activityList == null || activityList.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        if (activityList != null && activityList.getLength() > 0) {
            elements = new ArrayList();
            for (int i = 0; i < activityList.getLength(); ++i) {
                Node activity = activityList.item(i);
                if (!(activity instanceof Element)) continue;
                elements.add((Element)activity);
            }
        }
        return elements;
    }

    public static List<Element> elements(Element element, String ns, String localName) {
        if (element == null) {
            return Collections.emptyList();
        }
        NodeList activityList = element.getChildNodes();
        if (activityList == null || activityList.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element) || n.getLocalName() == null || !n.getLocalName().equals(localName) || n.getNamespaceURI() == null || !n.getNamespaceURI().equals(ns)) continue;
            matchingElements.add((Element)n);
        }
        return matchingElements;
    }

    public static List<Element> elementsQName(Element element, Set<QName> allowedTagNames) {
        if (element == null) {
            return Collections.emptyList();
        }
        NodeList activityList = element.getChildNodes();
        if (activityList == null || activityList.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        if (activityList != null) {
            for (int i = 0; i < activityList.getLength(); ++i) {
                Element childElement;
                QName childElementQName;
                Node child = activityList.item(i);
                if (!Element.class.isAssignableFrom(child.getClass()) || !allowedTagNames.contains(childElementQName = new QName((childElement = (Element)child).getNamespaceURI(), childElement.getLocalName()))) continue;
                if (elements == null) {
                    elements = new ArrayList();
                }
                elements.add(childElement);
            }
        }
        return elements;
    }

    public static Element element(Element element) {
        Element onlyChild = null;
        List<Element> elements = XmlUtil.elements(element);
        if (!elements.isEmpty()) {
            onlyChild = elements.get(0);
        }
        return onlyChild;
    }

    public static String toString(Node node) {
        if (node == null) {
            return "null";
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerException e) {
            throw new JbpmException("could not transform dom node to string", (Throwable)e);
        }
    }

    public static String getContentText(Element element) {
        return element.getTextContent();
    }

    public static boolean isTextOnly(Element element) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    public static List<Attr> attributes(Element element) {
        NamedNodeMap attributeMap = element.getAttributes();
        if (attributeMap == null || attributeMap.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Attr> attributes = new ArrayList<Attr>();
        for (int i = 0; i < attributeMap.getLength(); ++i) {
            attributes.add((Attr)attributeMap.item(i));
        }
        return attributes;
    }

    public static List<Node> contents(Element element) {
        NodeList activityList = element.getChildNodes();
        if (activityList == null || activityList.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Node> contents = new ArrayList<Node>();
        for (int i = 0; i < activityList.getLength(); ++i) {
            contents.add(activityList.item(i));
        }
        return contents;
    }

    public static String getTagLocalName(Element element) {
        if (element == null) {
            return null;
        }
        String localName = element.getLocalName();
        if (localName != null) {
            return localName;
        }
        return element.getTagName();
    }

    public static String attribute(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    public static String attribute(Element element, String attributeName, boolean required, Parse parse) {
        return XmlUtil.attribute(element, attributeName, required, parse, null);
    }

    public static String attribute(Element element, String attributeName, boolean required, Parse parse, String defaultValue) {
        if (element.hasAttribute(attributeName)) {
            String value = element.getAttribute(attributeName);
            if (required && "".equals(value)) {
                parse.addProblem("attribute <" + XmlUtil.getTagLocalName(element) + " " + attributeName + "=\"\" is empty", element);
            }
            return value;
        }
        if (required) {
            parse.addProblem("attribute <" + XmlUtil.getTagLocalName(element) + " " + attributeName + "=\"...\" is required", element);
        }
        return defaultValue;
    }

    public static Integer attributeInteger(Element element, String attributeName, boolean required, Parse parse) {
        String valueText = XmlUtil.attribute(element, attributeName, required, parse);
        if (valueText != null) {
            try {
                return Integer.parseInt(valueText);
            }
            catch (NumberFormatException e) {
                parse.addProblem(XmlUtil.errorMessageAttribute(element, attributeName, valueText, "value not parsable as integer"), element);
            }
        }
        return null;
    }

    public static Boolean attributeBoolean(Element element, String attributeName, boolean required, Parse parse) {
        return XmlUtil.attributeBoolean(element, attributeName, required, parse, null);
    }

    public static Boolean attributeBoolean(Element element, String attributeName, boolean required, Parse parse, Boolean defaultValue) {
        String valueText = XmlUtil.attribute(element, attributeName, required, parse);
        if (valueText != null) {
            Boolean value = XmlUtil.parseBooleanValue(valueText);
            if (value == null) {
                parse.addProblem(XmlUtil.errorMessageAttribute(element, attributeName, valueText, "value not in {true, enabled, on, false, disabled, off}"), element);
            }
            return value;
        }
        return defaultValue;
    }

    public static Boolean parseBooleanValue(String valueText) {
        if (valueText != null) {
            if ("true".equals(valueText) || "enabled".equals(valueText) || "on".equals(valueText)) {
                return Boolean.TRUE;
            }
            if ("false".equals(valueText) || "disabled".equals(valueText) || "off".equals(valueText)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static String errorMessageAttribute(Element element, String attributeName, String attributeValue, String message) {
        return "attribute <" + XmlUtil.getTagLocalName(element) + " " + attributeName + "=\"" + attributeValue + "\" " + message;
    }

    public static List<String> parseList(Element element, String singularTagName) {
        String text = XmlUtil.attribute(element, singularTagName + "s");
        if ("*".equals(text)) {
            text = null;
        }
        if (element.hasAttribute(singularTagName)) {
            String eventText = element.getAttribute(singularTagName);
            text = text == null ? eventText : text + "," + eventText;
        }
        List<String> eventNames = XmlUtil.parseCommaSeparatedList(text);
        return eventNames;
    }

    public static List<String> parseCommaSeparatedList(String commaSeparatedListText) {
        ArrayList<String> entries = null;
        if (commaSeparatedListText != null && !"*".equals(commaSeparatedListText)) {
            StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListText, ", ");
            while (tokenizer.hasMoreTokens()) {
                if (entries == null) {
                    entries = new ArrayList<String>();
                }
                entries.add(tokenizer.nextToken());
            }
        }
        return entries;
    }

    public static NamespaceValue attributeNamespaceValue(Element element, String attributeName) {
        NamespaceValue namespaceValue = null;
        String text = XmlUtil.attribute(element, attributeName);
        if (text != null) {
            int colonIndex = text.indexOf(58);
            if (colonIndex == -1) {
                namespaceValue = new NamespaceValue(null, text);
            } else {
                String prefix = text.substring(0, colonIndex);
                String localPart = null;
                if (text.length() > colonIndex + 1) {
                    localPart = text.substring(colonIndex + 1);
                }
                namespaceValue = new NamespaceValue(prefix, localPart);
            }
        }
        return namespaceValue;
    }

    public static QName attributeQName(Element element, String attributeName) {
        QName qname = null;
        NamespaceValue namespaceValue = XmlUtil.attributeNamespaceValue(element, attributeName);
        String text = XmlUtil.attribute(element, attributeName);
        if (namespaceValue != null) {
            if (namespaceValue.prefix == null) {
                qname = new QName(text);
            } else {
                String uri = element.lookupNamespaceURI(namespaceValue.prefix);
                if (uri == null) {
                    throw new JbpmException("unknown prefix in qname " + text);
                }
                if (namespaceValue.localPart == null) {
                    throw new JbpmException("no local part in qname " + text);
                }
                qname = new QName(uri, namespaceValue.localPart, namespaceValue.prefix);
            }
        }
        return qname;
    }

    public static QName getQNameFromString(Element element, String qnameAsString) {
        if (qnameAsString == null || element == null) {
            return null;
        }
        int colonIndex = qnameAsString.indexOf(":");
        String prefix = qnameAsString.substring(0, colonIndex);
        String localName = qnameAsString.substring(colonIndex + 1);
        String ns = XmlUtil.getNamespaceURI(element, prefix);
        return new QName(ns, localName, prefix);
    }

    public static String getNamespaceURI(Node n, String prefix) {
        Node prefixDeclaration = n.getAttributes().getNamedItem("xmlns:" + prefix);
        if (prefixDeclaration != null) {
            return prefixDeclaration.getNodeValue();
        }
        return XmlUtil.getNamespaceURI(n.getParentNode(), prefix);
    }

    public static class NamespaceValue {
        public String prefix;
        public String localPart;

        public NamespaceValue(String prefix, String localPart) {
            this.prefix = prefix;
            this.localPart = localPart;
        }
    }
}

