/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.construct.SimpleFlowConstruct;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.NullMessageProcessor;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptingChainMessageProcessorBuilder
implements MessageProcessorBuilder {
    protected List processors = new ArrayList();
    protected String name;

    @Override
    public MessageProcessor build() throws MuleException {
        if (this.processors.isEmpty()) {
            return new NullMessageProcessor();
        }
        InterceptingMessageProcessor first = this.createInterceptingMessageProcessor(this.getMessageProcessor(this.processors.get(0)));
        InterceptingChainCompositeMessageProcessor composite = new InterceptingChainCompositeMessageProcessor(first, this.processors, this.name);
        InterceptingMessageProcessor current = first;
        for (int i = 1; i < this.processors.size(); ++i) {
            InterceptingMessageProcessor mp = this.createInterceptingMessageProcessor(this.getMessageProcessor(this.processors.get(i)));
            current.setListener(mp);
            current = mp;
        }
        return composite;
    }

    private MessageProcessor getMessageProcessor(Object processor) throws MuleException {
        if (processor instanceof MessageProcessor) {
            return (MessageProcessor)processor;
        }
        if (processor instanceof MessageProcessorBuilder) {
            return ((MessageProcessorBuilder)processor).build();
        }
        throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
    }

    public void setName(String name) {
        this.name = name;
    }

    private InterceptingMessageProcessor createInterceptingMessageProcessor(MessageProcessor processor) {
        if (processor instanceof InterceptingMessageProcessor) {
            return (InterceptingMessageProcessor)processor;
        }
        return new InterceptingMessageProcessorAdapter(processor);
    }

    public InterceptingChainMessageProcessorBuilder chain(MessageProcessor ... processors) {
        for (MessageProcessor messageProcessor : processors) {
            this.processors.add(messageProcessor);
        }
        return this;
    }

    public InterceptingChainMessageProcessorBuilder chain(List<MessageProcessor> processors) {
        if (processors != null) {
            this.processors.addAll(processors);
        }
        return this;
    }

    public InterceptingChainMessageProcessorBuilder chain(MessageProcessorBuilder ... builders) {
        for (MessageProcessorBuilder messageProcessorBuilder : builders) {
            this.processors.add(messageProcessorBuilder);
        }
        return this;
    }

    public InterceptingChainMessageProcessorBuilder chainBefore(MessageProcessor processor) {
        this.processors.add(0, processor);
        return this;
    }

    public InterceptingChainMessageProcessorBuilder chainBefore(MessageProcessorBuilder builder) {
        this.processors.add(0, builder);
        return this;
    }

    public String toString() {
        if (this.name != null) {
            return "InterceptingChainMessageProcessorBuilder '" + this.name + "'";
        }
        return super.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InterceptingChainCompositeMessageProcessor
    implements MessageProcessor,
    Lifecycle,
    FlowConstructAware,
    MuleContextAware {
        private Log log;
        private String name;
        private MessageProcessor firstInChain;
        private List<MessageProcessor> allProcessors;

        public InterceptingChainCompositeMessageProcessor(InterceptingMessageProcessor firstInChain, List<MessageProcessor> allProcessors, String name) {
            this.name = name;
            this.firstInChain = firstInChain;
            this.allProcessors = allProcessors;
            this.log = LogFactory.getLog(InterceptingChainCompositeMessageProcessor.class);
        }

        @Override
        public MuleEvent process(MuleEvent event) throws MuleException {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Invoking " + this + " with event " + event));
            }
            return this.firstInChain.process(event);
        }

        @Override
        public void initialise() throws InitialisationException {
            for (MessageProcessor processor : this.allProcessors) {
                if (!(processor instanceof Initialisable)) continue;
                ((Initialisable)((Object)processor)).initialise();
            }
        }

        @Override
        public void start() throws MuleException {
            for (MessageProcessor processor : this.allProcessors) {
                if (!(processor instanceof Startable)) continue;
                ((Startable)((Object)processor)).start();
            }
        }

        @Override
        public void stop() throws MuleException {
            for (MessageProcessor processor : this.allProcessors) {
                if (!(processor instanceof Stoppable)) continue;
                ((Stoppable)((Object)processor)).stop();
            }
        }

        @Override
        public void dispose() {
            for (MessageProcessor processor : this.allProcessors) {
                if (!(processor instanceof Disposable)) continue;
                ((Disposable)((Object)processor)).dispose();
            }
        }

        @Override
        public void setFlowConstruct(FlowConstruct flowConstruct) {
            for (MessageProcessor processor : this.allProcessors) {
                if (!(processor instanceof FlowConstructAware)) continue;
                ((FlowConstructAware)((Object)processor)).setFlowConstruct(flowConstruct);
            }
        }

        @Override
        public void setMuleContext(MuleContext context) {
            for (MessageProcessor processor : this.allProcessors) {
                if (!(processor instanceof MuleContextAware)) continue;
                ((MuleContextAware)((Object)processor)).setMuleContext(context);
            }
        }

        public String toString() {
            Iterator<MessageProcessor> mpIterator;
            StringBuffer string = new StringBuffer();
            string.append("InterceptingChainCompositeMessageProcessor ");
            if (this.name != null) {
                string.append(" '" + this.name + "' ");
            }
            if ((mpIterator = this.allProcessors.iterator()).hasNext()) {
                string.append("\n[ ");
                while (mpIterator.hasNext()) {
                    MessageProcessor mp = mpIterator.next();
                    string.append("\n  " + StringUtils.replace((String)mp.toString(), (String)"\n", (String)"\n  "));
                    if (!mpIterator.hasNext()) continue;
                    string.append(", ");
                }
                string.append("\n]");
            }
            return string.toString();
        }
    }

    static class InterceptingMessageProcessorAdapter
    extends AbstractInterceptingMessageProcessor {
        private MessageProcessor delegate;

        public InterceptingMessageProcessorAdapter(MessageProcessor mp) {
            this.delegate = mp;
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            MuleEvent delegateResult;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Invoking adapted MessageProcessor '" + this.delegate.getClass().getName() + "'"));
            }
            if (this.delegate instanceof OutboundEndpoint) {
                event = new DefaultMuleEvent(event.getMessage(), (OutboundEndpoint)this.delegate, event.getSession());
            }
            if ((delegateResult = this.delegate.process(event)) != null) {
                return this.processNext(delegateResult);
            }
            if (event.getFlowConstruct() instanceof SimpleFlowConstruct) {
                return this.processNext(OptimizedRequestContext.criticalSetEvent(event));
            }
            return null;
        }

        public void setNext(MessageProcessor next) {
            this.next = next;
        }

        public String toString() {
            return "InterceptingMessageProcessorAdapter [ target = '" + this.delegate.getClass().getName() + "' ]";
        }
    }
}

