/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.store.ObjectStore;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.UUID;
import org.mule.util.concurrent.DaemonThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMonitoredObjectStore<T extends Serializable>
implements ObjectStore<T>,
Runnable,
MuleContextAware,
Initialisable,
Disposable {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected MuleContext context;
    protected ScheduledThreadPoolExecutor scheduler;
    protected int maxEntries = 4000;
    protected int entryTTL = -1;
    protected int expirationInterval = 1000;
    protected String name = null;

    @Override
    public void initialise() throws InitialisationException {
        if (this.name == null) {
            this.name = UUID.getUUID();
        }
        if (this.expirationInterval <= 0) {
            throw new IllegalArgumentException(CoreMessages.propertyHasInvalidValue("expirationInterval", new Integer(this.expirationInterval)).toString());
        }
        if (this.scheduler == null) {
            this.scheduler = new ScheduledThreadPoolExecutor(1);
            this.scheduler.setThreadFactory((ThreadFactory)new DaemonThreadFactory(this.name + "-Monitor", this.getClass().getClassLoader()));
            this.scheduler.scheduleWithFixedDelay((Runnable)this, 0L, (long)this.expirationInterval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public final void run() {
        this.expire();
    }

    @Override
    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    public void setEntryTTL(int entryTTL) {
        this.entryTTL = entryTTL;
    }

    public void setExpirationInterval(int expirationInterval) {
        this.expirationInterval = expirationInterval;
    }

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void setScheduler(ScheduledThreadPoolExecutor scheduler) {
        this.scheduler = scheduler;
    }

    public void setName(String id) {
        this.name = id;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    public int getEntryTTL() {
        return this.entryTTL;
    }

    public int getExpirationInterval() {
        return this.expirationInterval;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public String getName() {
        return this.name;
    }

    public ScheduledThreadPoolExecutor getScheduler() {
        return this.scheduler;
    }

    protected abstract void expire();
}

