/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file.transformers;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.file.transformers.FileToByteArray;

public class FileToString
extends FileToByteArray {
    public FileToString() {
        this.registerSourceType(File.class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(byte[].class);
        this.setReturnDataType(DataTypeFactory.create(String.class));
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        byte[] bytes = src instanceof byte[] ? (byte[])src : (byte[])super.doTransform(src, encoding);
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new TransformerException((Transformer)this, (Throwable)uee);
        }
    }
}

