/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.acegi;

import java.util.Map;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.providers.AuthenticationProvider;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.SecurityException;
import org.mule.module.acegi.AcegiAuthenticationAdapter;
import org.mule.module.acegi.AcegiSecurityContextFactory;
import org.mule.security.AbstractSecurityProvider;

public class AcegiProviderAdapter
extends AbstractSecurityProvider
implements AuthenticationProvider {
    private AuthenticationProvider delegate;
    private Map securityProperties;

    public AcegiProviderAdapter() {
        super("acegi");
    }

    public AcegiProviderAdapter(AuthenticationProvider delegate) {
        this(delegate, "acegi");
    }

    public AcegiProviderAdapter(AuthenticationProvider delegate, String name) {
        super(name);
        this.delegate = delegate;
    }

    protected void doInitialise() throws InitialisationException {
        this.setSecurityContextFactory(new AcegiSecurityContextFactory());
    }

    public org.mule.api.security.Authentication authenticate(org.mule.api.security.Authentication authentication) throws SecurityException {
        Object auth = null;
        auth = authentication instanceof AcegiAuthenticationAdapter ? ((AcegiAuthenticationAdapter)authentication).getDelegate() : new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials());
        auth = this.delegate.authenticate(auth);
        return new AcegiAuthenticationAdapter((Authentication)auth, this.getSecurityProperties());
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        return this.delegate.authenticate(authentication);
    }

    public AuthenticationProvider getDelegate() {
        return this.delegate;
    }

    public void setDelegate(AuthenticationProvider delegate) {
        this.delegate = delegate;
    }

    public Map getSecurityProperties() {
        return this.securityProperties;
    }

    public void setSecurityProperties(Map securityProperties) {
        this.securityProperties = securityProperties;
    }
}

