/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transport.Connector;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.XaTransactionFactory;
import org.mule.transport.TransactedPollingMessageReceiver;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.JdbcUtils;
import org.mule.transport.jdbc.i18n.JdbcMessages;
import org.mule.util.ArrayUtils;
import org.mule.util.MapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcMessageReceiver
extends TransactedPollingMessageReceiver {
    public static final String RECEIVE_MESSAGE_IN_TRANSCTION = "receiveMessageInTransaction";
    public static final String RECEIVE_MESSAGES_IN_XA_TRANSCTION = "receiveMessagesInXaTransaction";
    protected JdbcConnector connector;
    protected String readStmt;
    protected String ackStmt;
    protected List readParams;
    protected List ackParams;
    public boolean receiveMessagesInXaTransaction = false;
    private volatile boolean aggregateResult;

    public JdbcMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint, String readStmt, String ackStmt) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.setFrequency(((JdbcConnector)connector).getPollingFrequency());
        boolean transactedEndpoint = endpoint.getTransactionConfig().isTransacted();
        boolean xaTransactedEndpoint = transactedEndpoint && endpoint.getTransactionConfig().getFactory() instanceof XaTransactionFactory;
        boolean receiveMessageInTransaction = MapUtils.getBooleanValue((Map)endpoint.getProperties(), (Object)RECEIVE_MESSAGE_IN_TRANSCTION, (boolean)false);
        this.setReceiveMessagesInTransaction(receiveMessageInTransaction && transactedEndpoint);
        if (receiveMessageInTransaction && !transactedEndpoint) {
            this.logger.warn((Object)JdbcMessages.forcePropertyNoTransaction(RECEIVE_MESSAGE_IN_TRANSCTION, "transaction"));
            receiveMessageInTransaction = false;
        }
        this.receiveMessagesInXaTransaction = MapUtils.getBooleanValue((Map)endpoint.getProperties(), (Object)RECEIVE_MESSAGES_IN_XA_TRANSCTION, (boolean)false);
        if (this.receiveMessagesInXaTransaction && !receiveMessageInTransaction) {
            this.logger.warn((Object)JdbcMessages.forceProperty(RECEIVE_MESSAGES_IN_XA_TRANSCTION, RECEIVE_MESSAGE_IN_TRANSCTION));
            this.receiveMessagesInXaTransaction = false;
        } else if (this.receiveMessagesInXaTransaction && this.isReceiveMessagesInTransaction() && !xaTransactedEndpoint) {
            this.logger.warn((Object)JdbcMessages.forcePropertyNoTransaction(RECEIVE_MESSAGES_IN_XA_TRANSCTION, "XA transaction"));
            this.receiveMessagesInXaTransaction = false;
        }
        this.connector = (JdbcConnector)connector;
        this.setReceiveMessagesInTransaction(endpoint.getTransactionConfig().isTransacted() && !this.connector.isTransactionPerMessage());
        this.readParams = new ArrayList();
        this.readStmt = this.connector.parseStatement(readStmt, this.readParams);
        this.ackParams = new ArrayList();
        this.ackStmt = this.connector.parseStatement(ackStmt, this.ackParams);
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    public void processMessage(Object message) throws Exception {
        Connection con = null;
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        try {
            con = this.connector.getConnection();
            MuleMessage muleMessage = this.createMuleMessage(message, this.endpoint.getEncoding());
            if (this.ackStmt != null) {
                if (this.aggregateResult) {
                    int[] nbRows;
                    List rows = (List)message;
                    Object[][] paramValuesArray = new Object[rows.size()][];
                    for (int i = 0; i < rows.size(); ++i) {
                        HashMap record = (HashMap)rows.get(i);
                        paramValuesArray[i] = this.connector.getParams(this.endpoint, this.ackParams, (MuleMessage)new DefaultMuleMessage((Object)record, this.connector.getMuleContext()), this.endpoint.getEndpointURI().getAddress());
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("SQL UPDATE: " + this.ackStmt + ", params = " + ArrayUtils.toString((Object)this.ackParams)));
                    }
                    if ((nbRows = this.connector.getQueryRunnerFor(this.endpoint).batch(con, this.ackStmt, paramValuesArray))[0] == 0) {
                        this.logger.warn((Object)".ack statement did not update any rows");
                    }
                    this.aggregateResult = false;
                } else {
                    int nbRows;
                    Object[] paramValues = this.connector.getParams(this.endpoint, this.ackParams, muleMessage, this.endpoint.getEndpointURI().getAddress());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("SQL UPDATE: " + this.ackStmt + ", params = " + ArrayUtils.toString((Object)paramValues)));
                    }
                    if ((nbRows = this.connector.getQueryRunnerFor(this.endpoint).update(con, this.ackStmt, paramValues)) == 0) {
                        this.logger.warn((Object)".ack statement did not update any rows");
                    }
                }
            }
            this.routeMessage(muleMessage);
        }
        catch (Exception ex) {
            if (tx != null) {
                tx.setRollbackOnly();
            }
            throw ex;
        }
        finally {
            if (tx == null || tx.isXA()) {
                JdbcUtils.close(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MuleMessage> getMessages() throws Exception {
        Connection con = null;
        try {
            Object results;
            List resultList;
            con = this.connector.getConnection();
            Object[] readParams = this.connector.getParams(this.endpoint, this.readParams, null, this.endpoint.getEndpointURI().getAddress());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("SQL QUERY: " + this.readStmt + ", params = " + ArrayUtils.toString((Object)readParams)));
            }
            if ((resultList = (List)(results = this.connector.getQueryRunnerFor(this.endpoint).query(con, this.readStmt, readParams, this.connector.getResultSetHandler()))) != null && resultList.size() > 1 && this.isReceiveMessagesInTransaction() && !this.receiveMessagesInXaTransaction) {
                this.aggregateResult = true;
                this.logger.warn((Object)JdbcMessages.moreThanOneMessageInTransaction(RECEIVE_MESSAGE_IN_TRANSCTION, RECEIVE_MESSAGES_IN_XA_TRANSCTION));
                ArrayList<MuleMessage> singleResultList = new ArrayList<MuleMessage>(1);
                singleResultList.add((MuleMessage)resultList);
                ArrayList<MuleMessage> arrayList = singleResultList;
                return arrayList;
            }
            List list = resultList;
            return list;
        }
        finally {
            if (TransactionCoordination.getInstance().getTransaction() == null) {
                JdbcUtils.close(con);
            }
        }
    }
}

