/*
 * $Id: ContentBasedRouter.java 18877 2010-08-08 01:37:52Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.config.dsl.routers;

import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.outbound.AbstractOutboundRouter;

/**
 * TODO
 */
public class ContentBasedRouter extends AbstractOutboundRouter
{
    @Override
    public MuleEvent route(MuleEvent theEvent) throws MessagingException
    {
        MuleMessage message = theEvent.getMessage();

        for (MessageProcessor target : routes)
        {
            if (isMatch(message))
            {
                MuleEvent event = RequestContext.cloneAndUpdateEventEndpoint(theEvent, target);
                try
                {
                    return target.process(event);
                }
                catch (MuleException e)
                {
                    throw new MessagingException(e.getI18nMessage(), event, e);
                }
            }
        }
        //TODO
        throw new RuntimeException("Event not processed");
    }

    public boolean isMatch(MuleMessage message) throws MessagingException
    {
        for (MessageProcessor target : routes)
        {
            if (target instanceof ImmutableEndpoint)
            {
                ImmutableEndpoint endpoint = (ImmutableEndpoint)target;
                if (endpoint.getFilter() == null || endpoint.getFilter().accept(message))
                {
                    return true;
                }
            }
            else
            {
                return true;
            }
        }
        return false;
    }
}
