/*
 * $Id: MuleDeployer.java 18983 2010-08-12 16:06:07Z dirk.olmes $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.launcher;

import java.io.IOException;
import java.net.URL;

/**
 *
 */
public interface MuleDeployer
{

    void deploy(Application app);

    void undeploy(Application app);

    /**
     * Installs packaged Mule apps from $MULE_HOME/apps directory.
     * @param packedMuleAppFileName filename of the packed Mule app (only name + ext)
     */
    Application installFromAppDir(String packedMuleAppFileName) throws IOException;

    Application installFrom(URL url) throws IOException;
}
