/*
 * $Id: RouterStats.java 16514 2010-01-19 01:42:51Z dirk.olmes $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.management.mbean;

import org.mule.management.stats.RouterStatistics;

import java.util.Map;

/**
 * <code>RouterStats</code> TODO
 */
public class RouterStats implements RouterStatsMBean
{

    private RouterStatistics statistics;

    public RouterStats(RouterStatistics statistics)
    {
        this.statistics = statistics;
    }

    public long getCaughtMessages()
    {
        return statistics.getCaughtMessages();
    }

    public long getNotRouted()
    {
        return statistics.getNotRouted();
    }

    public long getTotalReceived()
    {
        return statistics.getTotalReceived();
    }

    public long getTotalRouted()
    {
        return statistics.getTotalRouted();
    }

    public Map getRouted()
    {
        return statistics.getRouted();
    }

}
