/*
 * $Id: HttpTransformersMule1822TestCase.java 17512 2010-06-04 07:18:23Z dirk.olmes $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.http.issues;

import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.functional.StringAppendTestTransformer;

public class HttpTransformersMule1822TestCase extends FunctionalTestCase
{
    public static final String OUTBOUND_MESSAGE = "Test message";

    @Override
    protected String getConfigResources()
    {
        return "http-transformers-mule-1822-test.xml";
    }

    private MuleMessage sendTo(String uri) throws MuleException
    {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage message = client.send(uri, OUTBOUND_MESSAGE, null);
        assertNotNull(message);
        return message;
    }

    /**
     * With no transformer we expect just the modification from the FTC
     */
    public void testBase() throws Exception
    {
        assertEquals(OUTBOUND_MESSAGE  + " Received",
                sendTo("base").getPayloadAsString());
    }

    /**
     * But response transformers on the base model should be applied
     */
    public void testResponse() throws Exception
    {
        assertEquals(
                StringAppendTestTransformer.append(" response",
                        StringAppendTestTransformer.append(" response 2",
                                        OUTBOUND_MESSAGE + " Received")),
                sendTo("response").getPayloadAsString());
    }

    /**
     * Should also work with inbound transformers
     */
    public void testBoth() throws Exception
    {
        assertEquals(
            StringAppendTestTransformer.append(" response",
                StringAppendTestTransformer.append(" response 2",
                    StringAppendTestTransformer.append(" transformed 2",
                        StringAppendTestTransformer.appendDefault(OUTBOUND_MESSAGE)) + " Received")),
                sendTo("both").getPayloadAsString());
    }
}
