/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import java.io.IOException;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.StringUtils;

public class MailUtils {
    public static String internetAddressesToString(InternetAddress[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(80);
        for (int i = 0; i < addresses.length; ++i) {
            InternetAddress address = addresses[i];
            buf.append(address.getAddress());
            if (i >= addresses.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public static String internetAddressesToString(InternetAddress address) {
        return MailUtils.internetAddressesToString(new InternetAddress[]{address});
    }

    public static String mailAddressesToString(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(80);
        for (int i = 0; i < addresses.length; ++i) {
            Address address = addresses[i];
            buf.append(address.toString());
            if (i >= addresses.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public static String mailAddressesToString(Address address) {
        return MailUtils.mailAddressesToString(new Address[]{address});
    }

    public static InternetAddress[] stringToInternetAddresses(String address) throws AddressException {
        if (StringUtils.isNotBlank((String)address)) {
            return InternetAddress.parse((String)address, (boolean)false);
        }
        throw new IllegalArgumentException(CoreMessages.objectIsNull("Email address").toString());
    }

    public static void getAttachments(Multipart content, Map attachments) throws MessagingException, IOException {
        int x = 0;
        for (int i = 0; i < content.getCount(); ++i) {
            BodyPart p = content.getBodyPart(i);
            if (p.getContentType().indexOf("multipart/mixed") > -1) {
                Multipart m = (Multipart)p.getContent();
                MailUtils.getAttachments(m, attachments);
                continue;
            }
            String key = StringUtils.isNotEmpty((String)p.getDescription()) ? p.getDescription() : (StringUtils.isNotEmpty((String)p.getFileName()) ? p.getFileName() : (StringUtils.isNotEmpty((String)p.getDisposition()) ? p.getDisposition() : String.valueOf(x++)));
            attachments.put(key, p);
        }
    }

    public static boolean isListHeader(String name) {
        return null != name && name.startsWith("List:");
    }

    public static String toListHeader(String header) {
        if (MailUtils.isListHeader(header)) {
            return header;
        }
        return "List:" + header;
    }
}

