/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transport.OutputHandler;
import org.mule.transport.jms.JmsConnector;
import org.mule.util.ArrayUtils;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsMessageUtils {
    public static final char REPLACEMENT_CHAR = '_';
    private static final Log logger = LogFactory.getLog(JmsMessageUtils.class);

    public static String encodeHeader(String name) {
        int i;
        boolean nonCompliant = false;
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Header name to encode must not be null or empty");
        }
        int length = name.length();
        for (i = 0; i < length && Character.isJavaIdentifierPart(name.charAt(i)); ++i) {
        }
        if (i == length) {
            return name;
        }
        StringBuffer sb = new StringBuffer(name);
        for (int j = i; j < length; ++j) {
            if (Character.isJavaIdentifierPart(sb.charAt(j))) continue;
            sb.setCharAt(j, '_');
            nonCompliant = true;
        }
        if (nonCompliant) {
            logger.warn((Object)MessageFormat.format("Header: {0} is not compliant with JMS specification (sec. 3.5.1, 3.8.1.1). It will cause problems in your and other applications. Please update your application code to correct this. Mule renamed it to {1}", name, sb.toString()));
        }
        return sb.toString();
    }

    public static Message toMessage(Object object, Session session) throws JMSException {
        if (object instanceof Message) {
            return (Message)object;
        }
        if (object instanceof String) {
            return JmsMessageUtils.stringToMessage((String)object, session);
        }
        if (object instanceof Map && JmsMessageUtils.validateMapMessageType((Map)object)) {
            return JmsMessageUtils.mapToMessage((Map)object, session);
        }
        if (object instanceof InputStream) {
            return JmsMessageUtils.inputStreamToMessage((InputStream)object, session);
        }
        if (object instanceof List) {
            return JmsMessageUtils.listToMessage((List)object, session);
        }
        if (object instanceof byte[]) {
            return JmsMessageUtils.byteArrayToMessage((byte[])object, session);
        }
        if (object instanceof Serializable) {
            return JmsMessageUtils.serializableToMessage((Serializable)object, session);
        }
        if (object instanceof OutputHandler) {
            return JmsMessageUtils.outputHandlerToMessage((OutputHandler)object, session);
        }
        throw new JMSException("Source was not of a supported type. Valid types are Message, String, Map, InputStream, List, byte[], Serializable or OutputHandler, but was " + ClassUtils.getShortClassName((Object)object, (String)"<null>"));
    }

    private static Message stringToMessage(String value, Session session) throws JMSException {
        return session.createTextMessage(value);
    }

    private static Message mapToMessage(Map<?, ?> value, Session session) throws JMSException {
        MapMessage mMsg = session.createMapMessage();
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            mMsg.setObject(entry.getKey().toString(), entry.getValue());
        }
        return mMsg;
    }

    private static Message inputStreamToMessage(InputStream value, Session session) throws JMSException {
        StreamMessage streamMessage = session.createStreamMessage();
        byte[] buffer = new byte[4096];
        try {
            int len;
            while ((len = value.read(buffer)) != -1) {
                streamMessage.writeBytes(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new JMSException("Failed to read input stream to create a stream message: " + e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)value);
        }
        return streamMessage;
    }

    private static Message listToMessage(List<?> value, Session session) throws JMSException {
        StreamMessage sMsg = session.createStreamMessage();
        for (Object o : value) {
            if (JmsMessageUtils.validateStreamMessageType(o)) {
                sMsg.writeObject(o);
                continue;
            }
            throw new MessageFormatException(String.format("Invalid type passed to StreamMessage: %s . Allowed types are: Boolean, Byte, Short, Character, Integer, Long, Float, Double,String and byte[]", ClassUtils.getShortClassName(o, (String)"null")));
        }
        return sMsg;
    }

    private static Message byteArrayToMessage(byte[] value, Session session) throws JMSException {
        BytesMessage bMsg = session.createBytesMessage();
        bMsg.writeBytes(value);
        return bMsg;
    }

    private static Message serializableToMessage(Serializable value, Session session) throws JMSException {
        ObjectMessage oMsg = session.createObjectMessage();
        oMsg.setObject(value);
        return oMsg;
    }

    private static Message outputHandlerToMessage(OutputHandler value, Session session) throws JMSException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            value.write(null, (OutputStream)output);
        }
        catch (IOException e) {
            JMSException j = new JMSException("Could not serialize OutputHandler.");
            j.initCause((Throwable)e);
            throw j;
        }
        BytesMessage bMsg = session.createBytesMessage();
        bMsg.writeBytes(output.toByteArray());
        return bMsg;
    }

    public static Object toObject(Message source, String jmsSpec, String encoding) throws JMSException, IOException {
        if (source instanceof ObjectMessage) {
            return ((ObjectMessage)source).getObject();
        }
        if (source instanceof MapMessage) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            MapMessage m = (MapMessage)source;
            Enumeration e = m.getMapNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object obj = m.getObject(name);
                map.put(name, obj);
            }
            return map;
        }
        if (source instanceof TextMessage) {
            return ((TextMessage)source).getText();
        }
        if (source instanceof BytesMessage) {
            return JmsMessageUtils.toByteArray(source, jmsSpec, encoding);
        }
        if (source instanceof StreamMessage) {
            ArrayList<Object> result = new ArrayList<Object>();
            try {
                Object obj;
                StreamMessage sMsg = (StreamMessage)source;
                while ((obj = sMsg.readObject()) != null) {
                    result.add(obj);
                }
            }
            catch (MessageEOFException eof) {
            }
            catch (Exception e) {
                throw new JMSException("Failed to extract information from JMS Stream Message: " + e);
            }
            return result;
        }
        return source;
    }

    public static byte[] toByteArray(Message message, String jmsSpec, String encoding) throws JMSException, IOException {
        if (message instanceof BytesMessage) {
            int len;
            BytesMessage bMsg = (BytesMessage)message;
            bMsg.reset();
            if ("1.1".equals(jmsSpec)) {
                long bmBodyLength = bMsg.getBodyLength();
                if (bmBodyLength > Integer.MAX_VALUE) {
                    throw new JMSException("Size of BytesMessage exceeds Integer.MAX_VALUE; please consider using JMS StreamMessage instead");
                }
                if (bmBodyLength > 0L) {
                    byte[] bytes = new byte[(int)bmBodyLength];
                    bMsg.readBytes(bytes);
                    return bytes;
                }
                return ArrayUtils.EMPTY_BYTE_ARRAY;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            byte[] buffer = new byte[4096];
            while ((len = bMsg.readBytes(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            if (baos.size() > 0) {
                return baos.toByteArray();
            }
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        if (message instanceof StreamMessage) {
            int len;
            StreamMessage sMsg = (StreamMessage)message;
            sMsg.reset();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            byte[] buffer = new byte[4096];
            while ((len = sMsg.readBytes(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            return baos.toByteArray();
        }
        if (message instanceof ObjectMessage) {
            ObjectMessage oMsg = (ObjectMessage)message;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream((OutputStream)baos);
            os.writeObject(oMsg.getObject());
            os.flush();
            os.close();
            return baos.toByteArray();
        }
        if (message instanceof TextMessage) {
            TextMessage tMsg = (TextMessage)message;
            String tMsgText = tMsg.getText();
            if (null == tMsgText) {
                return ArrayUtils.EMPTY_BYTE_ARRAY;
            }
            return tMsgText.getBytes(encoding);
        }
        throw new JMSException("Cannot get bytes from Map Message");
    }

    public static String getNameForDestination(Destination dest) throws JMSException {
        if (dest instanceof Queue) {
            return ((Queue)dest).getQueueName();
        }
        if (dest instanceof Topic) {
            return ((Topic)dest).getTopicName();
        }
        return null;
    }

    public static Message copyJMSProperties(Message from, Message to, JmsConnector connector) throws JMSException {
        if (connector.supportsProperty("JMSCorrelationID")) {
            to.setJMSCorrelationID(from.getJMSCorrelationID());
        }
        if (connector.supportsProperty("JMSDeliveryMode")) {
            to.setJMSDeliveryMode(from.getJMSDeliveryMode());
        }
        if (connector.supportsProperty("JMSDestination")) {
            to.setJMSDestination(from.getJMSDestination());
        }
        if (connector.supportsProperty("JMSExpiration")) {
            to.setJMSExpiration(from.getJMSExpiration());
        }
        if (connector.supportsProperty("JMSMessageID")) {
            to.setJMSMessageID(from.getJMSMessageID());
        }
        if (connector.supportsProperty("JMSPriority")) {
            to.setJMSPriority(from.getJMSPriority());
        }
        if (connector.supportsProperty("JMSRedelivered")) {
            to.setJMSRedelivered(from.getJMSRedelivered());
        }
        if (connector.supportsProperty("JMSReplyTo")) {
            to.setJMSReplyTo(from.getJMSReplyTo());
        }
        if (connector.supportsProperty("JMSTimestamp")) {
            to.setJMSTimestamp(from.getJMSTimestamp());
        }
        if (connector.supportsProperty("JMSType")) {
            to.setJMSType(from.getJMSType());
        }
        return to;
    }

    protected static boolean validateStreamMessageType(Object candidate) {
        return candidate == null || candidate instanceof Boolean || candidate instanceof Byte || candidate instanceof Short || candidate instanceof Character || candidate instanceof Integer || candidate instanceof Long || candidate instanceof Float || candidate instanceof Double || candidate instanceof String || candidate instanceof byte[];
    }

    protected static boolean validateMapMessageType(Map<?, ?> candidate) {
        for (Object o : candidate.values()) {
            if (JmsMessageUtils.validateStreamMessageType(o)) continue;
            return false;
        }
        return true;
    }
}

