/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.activemq;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.mule.api.MuleContext;
import org.mule.transport.ConnectException;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.xa.TargetInvocationHandler;
import org.mule.util.ClassUtils;

public class ActiveMQJmsConnector
extends JmsConnector {
    public static final String ACTIVEMQ_CONNECTION_FACTORY_CLASS = "org.apache.activemq.ActiveMQConnectionFactory";
    public static final String DEFAULT_BROKER_URL = "vm://localhost?broker.persistent=false&broker.useJmx=false";
    private String brokerURL = "vm://localhost?broker.persistent=false&broker.useJmx=false";

    public ActiveMQJmsConnector(MuleContext context) {
        super(context);
        this.setEagerConsumer(false);
    }

    protected ConnectionFactory getDefaultConnectionFactory() throws Exception {
        ConnectionFactory connectionFactory = (ConnectionFactory)ClassUtils.instanciateClass(ACTIVEMQ_CONNECTION_FACTORY_CLASS, this.getBrokerURL());
        this.applyVendorSpecificConnectionFactoryProperties(connectionFactory);
        return connectionFactory;
    }

    protected void applyVendorSpecificConnectionFactoryProperties(ConnectionFactory connectionFactory) {
        try {
            Method getRedeliveryPolicyMethod = connectionFactory.getClass().getMethod("getRedeliveryPolicy", new Class[0]);
            Object redeliveryPolicy = getRedeliveryPolicyMethod.invoke((Object)connectionFactory, new Object[0]);
            Method setMaximumRedeliveriesMethod = redeliveryPolicy.getClass().getMethod("setMaximumRedeliveries", Integer.TYPE);
            setMaximumRedeliveriesMethod.invoke(redeliveryPolicy, this.getMaxRedelivery() + 1);
        }
        catch (Exception e) {
            this.logger.error((Object)("Can not set MaxRedelivery parameter to RedeliveryPolicy " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doDisconnect() throws ConnectException {
        block18: {
            block16: {
                try {
                    try {
                        block17: {
                            connection = this.getConnection();
                            if (connection == null) {
                                var10_3 = null;
                                break block16;
                            }
                            clazz = connection.getClass();
                            if (Proxy.isProxyClass(clazz)) {
                                handler = (TargetInvocationHandler)Proxy.getInvocationHandler(connection);
                                connection = (Connection)handler.getTargetObject();
                                realConnectionClass = connection.getClass();
                                cleanupMethod = realConnectionClass.getMethod("cleanup", null);
                            } else {
                                cleanupMethod = clazz.getMethod("cleanup", null);
                            }
                            try {
                                if (cleanupMethod == null) break block17;
                                cleanupMethod.invoke((Object)connection, (Object[])null);
                            }
                            catch (InvocationTargetException ex) {
                                this.logger.warn((Object)"Exception cleaning up JMS connection", (Throwable)ex);
                                var7_12 = null;
                                try {
                                    connection.close();
                                }
                                catch (JMSException ex) {
                                    this.logger.warn((Object)"Exception closing JMS connection", (Throwable)ex);
                                }
                                break block18;
                            }
                        }
                        var7_11 = null;
                        {
                            catch (Throwable var6_17) {
                                var7_13 = null;
                                ** try [egrp 4[TRYBLOCK] [4 : 128->137)] { 
lbl39:
                                // 1 sources

                                connection.close();
                                throw var6_17;
lbl41:
                                // 1 sources

                                catch (JMSException ex) {
                                    this.logger.warn((Object)"Exception closing JMS connection", (Throwable)ex);
                                }
                                throw var6_17;
                            }
                            try {}
                            catch (JMSException ex) {}
                            this.logger.warn((Object)"Exception closing JMS connection", (Throwable)ex);
                            break block18;
                            connection.close();
                        }
                    }
                    catch (Exception e) {
                        throw new ConnectException(e, (Object)this);
                    }
                }
                catch (Throwable var9_18) {
                    var10_5 = null;
                    this.setConnection(null);
                    throw var9_18;
                }
            }
            this.setConnection(null);
            return;
        }
        var10_4 = null;
        this.setConnection(null);
    }

    public String getBrokerURL() {
        return this.brokerURL;
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = brokerURL;
    }
}

