/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.vm;

import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.activation.DataHandler;
import org.mule.DefaultMuleMessage;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.PollingReceiverWorker;
import org.mule.transport.TransactedPollingMessageReceiver;
import org.mule.transport.vm.VMConnector;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMMessageReceiver
extends TransactedPollingMessageReceiver {
    private VMConnector connector;

    public VMMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.setReceiveMessagesInTransaction(endpoint.getTransactionConfig().isTransacted());
        this.connector = (VMConnector)connector;
    }

    @Override
    protected void schedule() throws RejectedExecutionException, NullPointerException, IllegalArgumentException {
        if (!this.endpoint.getExchangePattern().hasResponse()) {
            super.schedule();
        }
    }

    @Override
    protected void doDispose() {
    }

    @Override
    protected void doConnect() throws Exception {
        if (!this.endpoint.getExchangePattern().hasResponse()) {
            QueueSession queueSession = this.connector.getQueueSession();
            Queue q = queueSession.getQueue(this.endpoint.getEndpointURI().getAddress());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Current queue depth for queue: " + this.endpoint.getEndpointURI().getAddress() + " is: " + q.size()));
            }
        }
    }

    @Override
    protected void doDisconnect() throws Exception {
    }

    public void onMessage(MuleMessage message) throws MuleException {
        DefaultMuleMessage newMessage = new DefaultMuleMessage(message.getPayload(), message, this.connector.getMuleContext());
        this.routeMessage(newMessage);
    }

    public MuleMessage onCall(MuleMessage message, boolean synchronous) throws MuleException {
        try {
            MuleMessage returnedMessage;
            MuleMessage newMessage = message.createInboundMessage();
            MuleEvent event = this.routeMessage(newMessage);
            MuleMessage muleMessage = returnedMessage = event == null ? null : event.getMessage();
            if (returnedMessage != null) {
                returnedMessage = returnedMessage.createInboundMessage();
            }
            return returnedMessage;
        }
        catch (Exception e) {
            throw new DefaultMuleException(e);
        }
    }

    protected MuleMessage createMessageCopy(MuleMessage message, boolean reinitialize) throws Exception {
        HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>(3);
        for (String name : message.getOutboundAttachmentNames()) {
            attachments.put(name, message.getOutboundAttachment(name));
        }
        HashMap properties = new HashMap(3);
        for (String name : message.getOutboundPropertyNames()) {
            properties.put(name, message.getOutboundProperty(name));
        }
        DefaultMuleMessage newMessage = new DefaultMuleMessage(message.getPayload(), message, this.connector.getMuleContext());
        if (reinitialize) {
            newMessage.clearProperties(PropertyScope.INBOUND);
            newMessage.clearProperties(PropertyScope.INVOCATION);
            newMessage.clearProperties(PropertyScope.OUTBOUND);
        }
        for (String s : properties.keySet()) {
            newMessage.setInboundProperty(s, properties.get(s));
        }
        if (reinitialize) {
            for (String s : newMessage.getOutboundAttachmentNames()) {
                newMessage.removeOutboundAttachment(s);
            }
        }
        for (String s : attachments.keySet()) {
            newMessage.addInboundAttachment(s, (DataHandler)attachments.get(s));
        }
        newMessage.setCorrelationId(message.getCorrelationId());
        newMessage.setCorrelationGroupSize(message.getCorrelationGroupSize());
        newMessage.setCorrelationSequence(message.getCorrelationSequence());
        newMessage.setReplyTo(message.getReplyTo());
        newMessage.setEncoding(message.getEncoding());
        return newMessage;
    }

    @Override
    protected List<MuleMessage> getMessages() throws Exception {
        if (this.isReceiveMessagesInTransaction()) {
            MuleEvent message = this.getFirstMessage();
            if (message == null) {
                return null;
            }
            ArrayList<MuleMessage> messages = new ArrayList<MuleMessage>(1);
            messages.add(message.getMessage());
            return messages;
        }
        return this.getFirstMessages();
    }

    protected List<MuleMessage> getFirstMessages() throws Exception {
        QueueSession qs = this.connector.getQueueSession();
        Queue queue = qs.getQueue(this.endpoint.getEndpointURI().getAddress());
        LinkedList<MuleMessage> messages = new LinkedList<MuleMessage>();
        int maxThreads = this.connector.getReceiverThreadingProfile().getMaxThreadsActive();
        int batchSize = Math.max(1, Math.min(queue.size(), maxThreads / 2 - 1));
        MuleEvent message = (MuleEvent)queue.poll(this.connector.getQueueTimeout());
        if (message != null) {
            messages.add(message.getMessage());
            for (int i = 0; i < batchSize && message != null; ++i) {
                message = (MuleEvent)queue.poll(0L);
                if (message == null) continue;
                messages.add(message.getMessage());
            }
        }
        return messages;
    }

    protected MuleEvent getFirstMessage() throws Exception {
        QueueSession qs = this.connector.getQueueSession();
        Queue queue = qs.getQueue(this.endpoint.getEndpointURI().getAddress());
        return (MuleEvent)queue.poll(this.connector.getQueueTimeout());
    }

    @Override
    protected void processMessage(Object msg) throws Exception {
        MuleMessage message = (MuleMessage)msg;
        MuleMessage newMessage = message.createInboundMessage();
        this.routeMessage(newMessage);
    }

    @Override
    protected PollingReceiverWorker createWork() {
        return new VMReceiverWorker(this);
    }

    protected static class VMReceiverWorker
    extends PollingReceiverWorker {
        public VMReceiverWorker(VMMessageReceiver pollingMessageReceiver) {
            super(pollingMessageReceiver);
        }

        public void run() {
            while (this.getReceiver().isConnected()) {
                super.run();
            }
        }
    }
}

