/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.List;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.DisposeException;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.AbstractReceiverResourceWorker;
import org.mule.transport.ConnectException;
import org.mule.transport.tcp.TcpConnector;
import org.mule.transport.tcp.TcpInputStream;
import org.mule.transport.tcp.TcpProtocol;
import org.mule.transport.tcp.i18n.TcpMessages;
import org.mule.util.monitor.Expirable;

public class TcpMessageReceiver
extends AbstractMessageReceiver
implements Work {
    private ServerSocket serverSocket = null;
    protected final AtomicBoolean disposing = new AtomicBoolean(false);

    public TcpMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
    }

    protected void doConnect() throws ConnectException {
        this.disposing.set(false);
        URI uri = this.endpoint.getEndpointURI().getUri();
        try {
            this.serverSocket = ((TcpConnector)this.connector).getServerSocket(uri);
        }
        catch (Exception e) {
            throw new ConnectException(TcpMessages.failedToBindToUri(uri), e, this);
        }
        try {
            this.getWorkManager().scheduleWork(this, Long.MAX_VALUE, null, this.connector);
        }
        catch (WorkException e) {
            throw new ConnectException(CoreMessages.failedToScheduleWork(), e, this);
        }
    }

    protected void doDisconnect() throws ConnectException {
        this.disposing.set(true);
        try {
            if (this.serverSocket != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Closing: " + this.serverSocket));
                }
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            this.logger.warn((Object)("Failed to close server socket: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void run() {
        while (!this.disposing.get()) {
            if (!this.connector.isStarted() || this.disposing.get()) continue;
            try {
                this.retryTemplate.execute(new RetryCallback(){

                    public void doWork(RetryContext context) throws Exception {
                        Socket socket;
                        block3: {
                            socket = null;
                            try {
                                socket = TcpMessageReceiver.this.serverSocket.accept();
                            }
                            catch (Exception e) {
                                if (TcpMessageReceiver.this.connector.isDisposed() || TcpMessageReceiver.this.disposing.get()) break block3;
                                throw new ConnectException(e, null);
                            }
                        }
                        if (socket != null) {
                            Work work = TcpMessageReceiver.this.createWork(socket);
                            TcpMessageReceiver.this.getWorkManager().scheduleWork(work, Long.MAX_VALUE, null, TcpMessageReceiver.this.connector);
                        }
                    }

                    public String getWorkDescription() {
                        return TcpMessageReceiver.this.getConnectionDescription();
                    }
                }, this.getWorkManager());
            }
            catch (Exception e) {
                this.getConnector().getMuleContext().getExceptionListener().handleException(e);
            }
        }
    }

    public void release() {
    }

    protected void doDispose() {
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Closing: " + this.serverSocket));
                }
                this.serverSocket.close();
            }
            this.serverSocket = null;
        }
        catch (Exception e) {
            this.logger.error((Object)new DisposeException(TcpMessages.failedToCloseSocket(), (Throwable)e, this));
        }
        this.logger.info((Object)"Closed Tcp port");
    }

    protected Work createWork(Socket socket) throws IOException {
        return new TcpWorker(socket, this);
    }

    protected class TcpWorker
    extends AbstractReceiverResourceWorker
    implements Disposable,
    Expirable {
        protected Socket socket;
        protected TcpInputStream dataIn;
        protected InputStream underlyingIn;
        protected OutputStream dataOut;
        protected TcpProtocol protocol;
        protected boolean dataInWorkFinished;
        protected Object notify;
        private boolean moreMessages;

        public TcpWorker(Socket socket, AbstractMessageReceiver receiver) throws IOException {
            super(socket, receiver, (OutputStream)((TcpConnector)TcpMessageReceiver.this.connector).getTcpProtocol().createResponse(socket));
            this.socket = null;
            this.dataInWorkFinished = false;
            this.notify = new Object();
            this.moreMessages = true;
            this.socket = socket;
            TcpConnector tcpConnector = (TcpConnector)TcpMessageReceiver.this.connector;
            this.protocol = tcpConnector.getTcpProtocol();
            try {
                tcpConnector.configureSocket(false, socket);
                this.underlyingIn = new BufferedInputStream(socket.getInputStream());
                this.dataIn = new TcpInputStream(this.underlyingIn){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close() throws IOException {
                        TcpWorker.this.dataInWorkFinished = true;
                        TcpWorker.this.moreMessages = false;
                        Object object = TcpWorker.this.notify;
                        synchronized (object) {
                            TcpWorker.this.notify.notifyAll();
                        }
                    }
                };
                this.dataOut = new BufferedOutputStream(socket.getOutputStream());
            }
            catch (IOException e) {
                TcpMessageReceiver.this.logger.error((Object)("Failed to set Socket properties: " + e.getMessage()), (Throwable)e);
            }
        }

        public void expired() {
            this.dispose();
        }

        public void dispose() {
            this.releaseSocket();
        }

        public void release() {
            this.waitForStreams();
            this.releaseSocket();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForStreams() {
            if (!this.dataInWorkFinished) {
                Object object = this.notify;
                synchronized (object) {
                    if (!this.dataInWorkFinished) {
                        try {
                            this.notify.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        private void releaseSocket() {
            try {
                if (this.socket != null && !this.socket.isClosed()) {
                    if (TcpMessageReceiver.this.logger.isDebugEnabled()) {
                        SocketAddress socketAddress = this.socket.getLocalSocketAddress();
                        if (socketAddress == null) {
                            TcpMessageReceiver.this.logger.debug((Object)"Listener has already been closed by other process.");
                        } else {
                            TcpMessageReceiver.this.logger.debug((Object)("Closing listener: " + socketAddress));
                        }
                    }
                    this.shutdownSocket();
                    this.socket.close();
                }
            }
            catch (IOException e) {
                TcpMessageReceiver.this.logger.warn((Object)("Socket close failed with: " + e));
            }
        }

        protected void shutdownSocket() throws IOException {
            try {
                this.socket.shutdownOutput();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }

        protected void bindTransaction(Transaction tx) throws TransactionException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object getNextMessage(Object resource) throws Exception {
            long keepAliveTimeout = ((TcpConnector)TcpMessageReceiver.this.connector).getKeepAliveTimeout();
            Object readMsg = null;
            try {
                if (keepAliveTimeout > 0L) {
                    ((TcpConnector)TcpMessageReceiver.this.connector).getKeepAliveMonitor().addExpirable(keepAliveTimeout, TimeUnit.MILLISECONDS, this);
                }
                readMsg = this.protocol.read(this.dataIn);
                ((TcpConnector)TcpMessageReceiver.this.connector).getKeepAliveMonitor().removeExpirable(this);
                if (this.dataIn.isStreaming()) {
                    this.moreMessages = false;
                }
                Object object = readMsg;
                return object;
            }
            catch (SocketTimeoutException e) {
                ((TcpConnector)TcpMessageReceiver.this.connector).getKeepAliveMonitor().removeExpirable(this);
            }
            finally {
                if (readMsg == null) {
                    this.dataIn.close();
                }
            }
            return null;
        }

        protected boolean hasMoreMessages(Object message) {
            return !this.socket.isClosed() && !this.dataInWorkFinished && !TcpMessageReceiver.this.disposing.get() && this.moreMessages;
        }

        protected void handleResults(List messages) throws Exception {
            if (this.endpoint.getExchangePattern().hasResponse()) {
                for (Object o : messages) {
                    this.protocol.write(this.dataOut, o);
                    this.dataOut.flush();
                }
            }
        }

        protected void preRouteMuleMessage(MuleMessage message) throws Exception {
            super.preRouteMuleMessage(message);
            SocketAddress clientAddress = this.socket.getRemoteSocketAddress();
            if (clientAddress != null) {
                message.setOutboundProperty("MULE_REMOTE_CLIENT_ADDRESS", clientAddress.toString());
            }
        }
    }
}

