/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.transport.tcp.protocols.DirectProtocol;

public class LengthProtocol
extends DirectProtocol {
    private static final Log logger = LogFactory.getLog(LengthProtocol.class);
    private static final int SIZE_INT = 4;
    public static final int NO_MAX_LENGTH = -1;
    private int maxMessageLength;

    public LengthProtocol() {
        this(-1);
    }

    public LengthProtocol(int maxMessageLength) {
        super(false, 4);
        this.setMaxMessageLength(maxMessageLength);
    }

    public Object read(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        dis.mark(4);
        if (null == super.read(dis, 4)) {
            return null;
        }
        dis.reset();
        int length = dis.readInt();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("length: " + length));
        }
        if (length < 0 || this.getMaxMessageLength() > 0 && length > this.getMaxMessageLength()) {
            throw new IOException("Length " + length + " exceeds limit: " + this.getMaxMessageLength());
        }
        byte[] buffer = new byte[length];
        dis.readFully(buffer);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("length read: " + buffer.length));
        }
        return buffer;
    }

    protected void writeByteArray(OutputStream os, byte[] data) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeInt(data.length);
        dos.write(data);
        if (dos.size() != data.length + 4) {
            dos.flush();
        }
    }

    protected boolean isRepeat(int len, int available) {
        return true;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public void setMaxMessageLength(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }
}

