/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.io.IOException;
import java.io.InputStream;
import org.mule.api.component.Component;
import org.mule.api.component.JavaComponent;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.service.Service;
import org.mule.component.AbstractJavaComponent;
import org.mule.config.i18n.MessageFactory;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.construct.SimpleFlowConstruct;
import org.mule.construct.SimpleService;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.util.IOUtils;

public abstract class FunctionalTestCase
extends AbstractMuleTestCase {
    public FunctionalTestCase() {
        this.setStartContext(true);
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new SpringXmlConfigurationBuilder(this.getConfigResources());
    }

    protected abstract String getConfigResources();

    protected Object getComponent(String serviceName) throws Exception {
        FlowConstruct flowConstruct = (FlowConstruct)muleContext.getRegistry().lookupObject(serviceName);
        if (flowConstruct != null) {
            return this.getComponent(flowConstruct);
        }
        throw new RegistrationException(MessageFactory.createStaticMessage((String)("Service " + serviceName + " not found in Registry")));
    }

    protected Object getComponent(FlowConstruct flowConstruct) throws Exception {
        if (flowConstruct instanceof Service) {
            return this.getComponentObject(((Service)flowConstruct).getComponent());
        }
        if (flowConstruct instanceof SimpleService) {
            return this.getComponentObject(((SimpleService)flowConstruct).getComponent());
        }
        if (flowConstruct instanceof SimpleFlowConstruct) {
            SimpleFlowConstruct flow = (SimpleFlowConstruct)flowConstruct;
            for (MessageProcessor processor : flow.getMessageProcessors()) {
                if (!(processor instanceof Component)) continue;
                return this.getComponentObject((Component)processor);
            }
        }
        throw new RegistrationException(MessageFactory.createStaticMessage((String)("Can't get component from flow construct " + flowConstruct.getName())));
    }

    protected FunctionalTestComponent getFunctionalTestComponent(String serviceName) throws Exception {
        return (FunctionalTestComponent)this.getComponent(serviceName);
    }

    protected String loadResourceAsString(String name) throws IOException {
        return IOUtils.getResourceAsString((String)name, ((Object)((Object)this)).getClass());
    }

    protected InputStream loadResource(String name) throws IOException {
        return IOUtils.getResourceAsStream((String)name, ((Object)((Object)this)).getClass());
    }

    private Object getComponentObject(Component component) throws Exception {
        if (component instanceof JavaComponent) {
            return ((AbstractJavaComponent)component).getObjectFactory().getInstance(muleContext);
        }
        FunctionalTestCase.fail((String)"Component is not a JavaComponent and therefore has no component object instance");
        return null;
    }
}

