/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.processor.NullMessageProcessor;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratingListMessageProcessorBuilder
implements MessageProcessorBuilder {
    protected List processors = new ArrayList();
    protected String name;

    @Override
    public MessageProcessor build() throws MuleException {
        if (this.processors.isEmpty()) {
            return new NullMessageProcessor();
        }
        return new IteratingListCompositeMessageProcessor(this.processors, this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public IteratingListMessageProcessorBuilder add(MessageProcessor ... processors) {
        for (MessageProcessor messageProcessor : processors) {
            this.processors.add(messageProcessor);
        }
        return this;
    }

    public IteratingListMessageProcessorBuilder add(MessageProcessorBuilder ... builders) {
        for (MessageProcessorBuilder builder : builders) {
            this.processors.add(builder);
        }
        return this;
    }

    public IteratingListMessageProcessorBuilder InterceptingChainMessageProcessorBuilder(Collection<MessageProcessor> processors) {
        if (processors != null) {
            this.processors.addAll(processors);
        }
        return this;
    }

    public IteratingListMessageProcessorBuilder addBefore(MessageProcessor processor) {
        this.processors.add(0, processor);
        return this;
    }

    public IteratingListMessageProcessorBuilder addBefore(MessageProcessorBuilder builder) {
        this.processors.add(0, builder);
        return this;
    }

    public String toString() {
        if (this.name != null) {
            return "IteratingListMessageProcessorBuilder '" + this.name + "'";
        }
        return super.toString();
    }

    static class IteratingListCompositeMessageProcessor
    implements MessageProcessor,
    Lifecycle,
    FlowConstructAware,
    MuleContextAware {
        private Log log;
        private String name;
        private List<MessageProcessor> list = new ArrayList<MessageProcessor>();

        public IteratingListCompositeMessageProcessor(List processors, String name) throws MuleException {
            this.name = name;
            for (MessageProcessor object : this.list) {
                this.list.add(this.getMessageProcessor(object));
            }
            this.log = LogFactory.getLog(IteratingListCompositeMessageProcessor.class);
        }

        private MessageProcessor getMessageProcessor(Object processor) throws MuleException {
            if (processor instanceof MessageProcessor) {
                return (MessageProcessor)processor;
            }
            if (processor instanceof MessageProcessorBuilder) {
                return ((MessageProcessorBuilder)processor).build();
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Invoking " + this + " with event " + event));
            }
            MuleEvent result = event;
            for (MessageProcessor processor : this.list) {
                result = processor.process(result);
            }
            return result;
        }

        public void initialise() throws InitialisationException {
            for (MessageProcessor processor : this.list) {
                if (!(processor instanceof Initialisable)) continue;
                ((Initialisable)((Object)processor)).initialise();
            }
        }

        public void start() throws MuleException {
            for (MessageProcessor processor : this.list) {
                if (!(processor instanceof Startable)) continue;
                ((Startable)((Object)processor)).start();
            }
        }

        public void stop() throws MuleException {
            for (MessageProcessor processor : this.list) {
                if (!(processor instanceof Stoppable)) continue;
                ((Stoppable)((Object)processor)).stop();
            }
        }

        public void dispose() {
            for (MessageProcessor processor : this.list) {
                if (!(processor instanceof Disposable)) continue;
                ((Disposable)((Object)processor)).dispose();
            }
        }

        public void setFlowConstruct(FlowConstruct flowConstruct) {
            for (MessageProcessor processor : this.list) {
                if (!(processor instanceof FlowConstructAware)) continue;
                ((FlowConstructAware)((Object)processor)).setFlowConstruct(flowConstruct);
            }
        }

        public void setMuleContext(MuleContext muleContext) {
            for (MessageProcessor processor : this.list) {
                if (!(processor instanceof MuleContextAware)) continue;
                ((MuleContextAware)((Object)processor)).setMuleContext(muleContext);
            }
        }

        public String toString() {
            Iterator<MessageProcessor> mpIterator;
            StringBuffer string = new StringBuffer();
            string.append("IteratingListCompositeMessageProcessor ");
            if (this.name != null) {
                string.append(" '" + this.name + "' ");
            }
            if ((mpIterator = this.list.iterator()).hasNext()) {
                string.append("\n[ ");
                while (mpIterator.hasNext()) {
                    MessageProcessor mp = mpIterator.next();
                    string.append("\n  " + StringUtils.replace((String)mp.toString(), (String)"\n", (String)"\n  "));
                    if (!mpIterator.hasNext()) continue;
                    string.append(", ");
                }
                string.append("\n]");
            }
            return string.toString();
        }
    }
}

