/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.IOException;
import java.io.InputStream;
import org.apache.axiom.attachments.MIMEBodyPartInputStream;

public class PushbackFilePartInputStream
extends InputStream {
    MIMEBodyPartInputStream inStream;
    byte[] buffer;
    int count;

    public PushbackFilePartInputStream(MIMEBodyPartInputStream inStream, byte[] buffer) {
        this.inStream = inStream;
        this.buffer = buffer;
        this.count = buffer.length;
    }

    public int read() throws IOException {
        int data;
        if (this.count > 0) {
            byte byteValue = this.buffer[this.buffer.length - this.count];
            data = byteValue & 0xFF;
            --this.count;
        } else {
            data = this.inStream.read();
        }
        return data;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.count > 0) {
            int start = this.buffer.length - this.count;
            int copyLen = Math.min(len, this.count);
            System.arraycopy(this.buffer, start, b, off, copyLen);
            this.count -= copyLen;
            if (len > copyLen) {
                return this.inStream.read(b, off + copyLen, len - copyLen) + copyLen;
            }
            return len;
        }
        return this.inStream.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int available() throws IOException {
        return this.count + this.inStream.available();
    }
}

