/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp;

import cryptix.openpgp.packet.PGPKeyPacket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;

public abstract class PGPKey
implements Key {
    private PGPKeyPacket packet;
    private String algorithm;

    protected PGPKey(PGPKeyPacket pkt, String algorithm) {
        if (pkt == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.packet = pkt;
        this.algorithm = algorithm;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof PGPKey)) {
            return false;
        }
        return this.packet.equals(((PGPKey)other).packet);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public int getBitLength() {
        return this.packet.getAlgorithm().getBitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.packet.encode(baos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new InternalError("IOException in ByteArrayOutputStream - " + ioe);
        }
    }

    public String getFormat() {
        return "OpenPGP";
    }

    public PGPKeyPacket getPacket() {
        return this.packet;
    }

    public boolean isLegacy() {
        return this.packet.getVersion() <= 3;
    }
}

