/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.algorithm;

import cryptix.jce.ElGamalKey;
import cryptix.jce.ElGamalParams;
import cryptix.jce.ElGamalPrivateKey;
import cryptix.jce.ElGamalPublicKey;
import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPDecryptionFailedException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPEncryptor;
import cryptix.openpgp.algorithm.PGPPublicKeyAlgorithm;
import cryptix.openpgp.algorithm.PGPSigner;
import cryptix.openpgp.io.PGPDataInputStream;
import cryptix.openpgp.io.PGPDataOutputStream;
import cryptix.openpgp.util.PGPDSAElGamalSignatureParser;
import cryptix.openpgp.util.PGPMPI;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class PGPElGamal
implements PGPSigner,
PGPEncryptor {
    private BigInteger p = null;
    private BigInteger g = null;
    private BigInteger x = null;
    private BigInteger y = null;
    private BigInteger r = null;
    private BigInteger s = null;
    private BigInteger a = null;
    private BigInteger b = null;
    private Signature sig;
    private Cipher cipher;

    public PGPElGamal() {
        try {
            this.cipher = Cipher.getInstance("ElGamal/ECB/PKCS#1", "CryptixCrypto");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace(System.err);
            throw new RuntimeException("ElGamal algorithm not found." + nsae);
        }
        catch (NoSuchPaddingException nsp) {
            nsp.printStackTrace();
            throw new RuntimeException("Couldn't use PKCS#1 padding");
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
            throw new RuntimeException("Cryptix JCE provider not found.");
        }
    }

    PGPElGamal(BigInteger p, BigInteger g, BigInteger y) {
        this();
        this.p = p;
        this.g = g;
        this.y = y;
    }

    PGPElGamal(BigInteger p, BigInteger g, BigInteger x, BigInteger y) {
        this();
        this.p = p;
        this.g = g;
        this.x = x;
        this.y = y;
    }

    public PGPPublicKeyAlgorithm clonePrivate() {
        return new PGPElGamal(this.p, this.g, this.x, this.y);
    }

    public PGPPublicKeyAlgorithm clonePublic() {
        return new PGPElGamal(this.p, this.g, this.y);
    }

    private static boolean compare(BigInteger a, BigInteger b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public void computeSignature() {
        throw new RuntimeException("Generating ElGamal signatures is not supported.");
    }

    public void decodeEncryptedData(PGPDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.a = in.readMPI();
        this.b = in.readMPI();
    }

    public void decodePublicData(PGPDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.p = in.readMPI();
        this.g = in.readMPI();
        this.y = in.readMPI();
    }

    public void decodeSecretData(PGPDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.x = in.readMPI();
    }

    public void decodeSignatureData(PGPDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.r = in.readMPI();
        this.s = in.readMPI();
        if (this.r == null || this.s == null) {
            throw new PGPDataFormatException("Invalid sig, r == null || s == null");
        }
        if (this.r.signum() != 1 || this.s.signum() != 1) {
            throw new PGPDataFormatException("Invalid sig, r <= 0 || s <= 0");
        }
    }

    public byte[] decrypt() throws PGPDecryptionFailedException {
        try {
            this.cipher = Cipher.getInstance("ElGamal/ECB/PKCS#1", "CryptixCrypto");
            this.cipher.init(2, new PGPElGamalPrivateKey());
            int cipherBlockSize = this.cipher.getBlockSize() / 2;
            byte[] one = PGPMPI.toFixedLenByteArray(this.a, cipherBlockSize);
            byte[] two = PGPMPI.toFixedLenByteArray(this.b, cipherBlockSize);
            byte[] ct = new byte[one.length + two.length];
            System.arraycopy(one, 0, ct, 0, one.length);
            System.arraycopy(two, 0, ct, one.length, two.length);
            return this.cipher.doFinal(ct);
        }
        catch (SecurityException se) {
            se.printStackTrace();
            throw new RuntimeException("Not allowed to use ElGamal. Perhaps you need to download the Unlimited Strength Jurisdiction Policy Files from the Sun website? " + se);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PGPDecryptionFailedException("Data larger than key. Wrong key used?");
        }
        catch (BadPaddingException badPaddingException) {
            throw new PGPDecryptionFailedException("Decrypted data != PKCS#1. Wrong key used?");
        }
        catch (IllegalBlockSizeException ibs) {
            ibs.printStackTrace();
            throw new InternalError("Illegal blocksize");
        }
        catch (InvalidKeyException ivk) {
            ivk.printStackTrace();
            throw new InternalError("Key was invalid");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            throw new RuntimeException("ElGamal algorithm not found. Provider problem?");
        }
        catch (NoSuchPaddingException nsp) {
            nsp.printStackTrace();
            throw new RuntimeException("Couldn't use PKCS#1 padding. Provider problem?");
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
            throw new RuntimeException("Cryptix JCE provider not found.");
        }
    }

    public void encodeEncryptedData(PGPDataOutputStream out) throws IOException {
        out.writeMPI(this.a);
        out.writeMPI(this.b);
    }

    public void encodePublicData(PGPDataOutputStream out) throws IOException {
        out.writeMPI(this.p);
        out.writeMPI(this.g);
        out.writeMPI(this.y);
    }

    public void encodeSecretData(PGPDataOutputStream out) throws IOException {
        out.writeMPI(this.x);
    }

    public void encodeSignatureData(PGPDataOutputStream out) throws IOException {
        out.writeMPI(this.r);
        out.writeMPI(this.s);
    }

    public void encrypt(byte[] data, SecureRandom sr) {
        try {
            this.cipher = Cipher.getInstance("ElGamal/ECB/PKCS#1", "CryptixCrypto");
            this.cipher.init(1, (Key)new PGPElGamalPublicKey(), sr);
            byte[] encrypted = this.cipher.doFinal(data);
            int halfsize = encrypted.length >> 1;
            byte[] one = new byte[halfsize];
            byte[] two = new byte[halfsize];
            System.arraycopy(encrypted, 0, one, 0, halfsize);
            System.arraycopy(encrypted, halfsize, two, 0, halfsize);
            this.a = new BigInteger(1, one);
            this.b = new BigInteger(1, two);
        }
        catch (SecurityException se) {
            se.printStackTrace();
            throw new RuntimeException("Not allowed to use ElGamal. Perhaps you need to download the Unlimited Strength Jurisdiction Policy Files from the Sun website? " + se);
        }
        catch (InvalidKeyException ivk) {
            ivk.printStackTrace();
            throw new InternalError("Key was invalid:");
        }
        catch (IllegalBlockSizeException ibs) {
            ibs.printStackTrace();
            throw new InternalError("Illegal blocksize");
        }
        catch (BadPaddingException bp) {
            bp.printStackTrace();
            throw new InternalError("Bad padding");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            throw new RuntimeException("ElGamal algorithm not found. Provider problem?");
        }
        catch (NoSuchPaddingException nsp) {
            nsp.printStackTrace();
            throw new RuntimeException("Couldn't use PKCS#1 padding. Provider problem?");
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
            throw new RuntimeException("Cryptix JCE provider not found.");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGPElGamal) {
            PGPElGamal objx = (PGPElGamal)obj;
            return objx.equals(this.p, this.g, this.x, this.y);
        }
        return false;
    }

    boolean equals(BigInteger p, BigInteger g, BigInteger x, BigInteger y) {
        return PGPElGamal.compare(this.p, p) && PGPElGamal.compare(this.g, g) && PGPElGamal.compare(this.x, x) && PGPElGamal.compare(this.y, y);
    }

    public void forgetSecretData() {
        this.x = null;
    }

    public void generateKeyPair(int keysize, SecureRandom sr) {
        KeyPairGenerator kpg;
        try {
            kpg = KeyPairGenerator.getInstance("ElGamal", "CryptixCrypto");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            throw new RuntimeException("Cannot find ElGamal implementation");
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
            throw new RuntimeException("Cryptix JCE provider not found.");
        }
        kpg.initialize(keysize, sr);
        KeyPair kp = ((KeyPairGeneratorSpi)kpg).generateKeyPair();
        this.p = ((ElGamalPublicKey)kp.getPublic()).getParams().getP();
        this.g = ((ElGamalPublicKey)kp.getPublic()).getParams().getG();
        this.y = ((ElGamalPublicKey)kp.getPublic()).getY();
        this.x = ((ElGamalPrivateKey)kp.getPrivate()).getX();
    }

    public int getBitLength() {
        return this.p.bitLength();
    }

    public ElGamalPrivateKey getElGamalPrivateKey() {
        return new PGPElGamalPrivateKey();
    }

    public ElGamalPublicKey getElGamalPublicKey() {
        return new PGPElGamalPublicKey();
    }

    public int hashCode() {
        int hash = 0;
        if (this.p != null) {
            hash ^= this.p.hashCode();
        }
        if (this.g != null) {
            hash ^= this.g.hashCode();
        }
        if (this.x != null) {
            hash ^= this.x.hashCode();
        }
        if (this.y != null) {
            hash ^= this.y.hashCode();
        }
        return hash;
    }

    public void initSign(int hashID, PGPAlgorithmFactory factory) {
        try {
            String h = factory.getHashAlgorithmString(hashID);
            this.sig = Signature.getInstance(String.valueOf(h) + "withElGamal", "CryptixCrypto");
            this.sig.initSign((PrivateKey)((Object)new PGPElGamalPrivateKey()));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException("InvalidKeyException");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            throw new RuntimeException("ElGamal algorithm not found.");
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
            throw new RuntimeException("Cryptix JCE provider not found.");
        }
    }

    public void initVerify(int hashID, PGPAlgorithmFactory factory) {
        try {
            String h = factory.getHashAlgorithmString(hashID);
            this.sig = Signature.getInstance(String.valueOf(h) + "withElGamal", "CryptixCrypto");
            this.sig.initVerify((PublicKey)((Object)new PGPElGamalPublicKey()));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException("InvalidKeyException");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            throw new RuntimeException("ElGamal algorithm not found.");
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
            throw new RuntimeException("Cryptix JCE provider not found.");
        }
    }

    public boolean signatureEquals(PGPSigner obj) {
        if (obj instanceof PGPElGamal) {
            PGPElGamal objx = (PGPElGamal)obj;
            return objx.signatureEquals(this.r, this.s);
        }
        return false;
    }

    boolean signatureEquals(BigInteger r, BigInteger s) {
        return PGPElGamal.compare(this.r, r) && PGPElGamal.compare(this.s, s);
    }

    public String toString() {
        return "ElGamal";
    }

    public void update(byte[] data) {
        try {
            this.sig.update(data);
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException("Signature not initialized");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Signature not initialized");
        }
    }

    public void update(byte[] data, int offset, int len) {
        try {
            this.sig.update(data, offset, len);
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException("Signature not initialized");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Signature not initialized");
        }
    }

    public boolean verifySignature() {
        PGPDSAElGamalSignatureParser parser = new PGPDSAElGamalSignatureParser(this.r, this.s);
        byte[] sigdata = parser.getData();
        try {
            return this.sig.verify(sigdata);
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException("SignatureException");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Signature not initialized");
        }
    }

    private class PGPElGamalParams
    implements ElGamalParams {
        PGPElGamalParams() {
        }

        public BigInteger getG() {
            return PGPElGamal.this.g;
        }

        public BigInteger getP() {
            return PGPElGamal.this.p;
        }

        public BigInteger getQ() {
            return null;
        }
    }

    private class PGPElGamalKey
    implements ElGamalKey,
    Key {
        PGPElGamalKey() {
        }

        public String getAlgorithm() {
            return "ElGamal";
        }

        public byte[] getEncoded() {
            return null;
        }

        public String getFormat() {
            return null;
        }

        public ElGamalParams getParams() {
            return new PGPElGamalParams();
        }
    }

    private class PGPElGamalPrivateKey
    extends PGPElGamalKey
    implements ElGamalPrivateKey {
        PGPElGamalPrivateKey() {
        }

        public BigInteger getX() {
            return PGPElGamal.this.x;
        }
    }

    private class PGPElGamalPublicKey
    extends PGPElGamalKey
    implements ElGamalPublicKey {
        PGPElGamalPublicKey() {
        }

        public BigInteger getY() {
            return PGPElGamal.this.y;
        }
    }
}

