/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.packet;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPCompressor;
import cryptix.openpgp.io.PGPCompressorInputStream;
import cryptix.openpgp.io.PGPCompressorOutputStream;
import cryptix.openpgp.io.PGPInputStreamAdapter;
import cryptix.openpgp.io.PGPOutputStreamAdapter;
import cryptix.openpgp.io.PGPPacketDataInputStream;
import cryptix.openpgp.io.PGPPacketDataOutputStream;
import cryptix.openpgp.io.PGPZLibInputStreamAdapter;
import cryptix.openpgp.packet.PGPContainerPacket;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class PGPCompressedDataPacket
extends PGPContainerPacket {
    private int compAlgId;

    public void decodeBody(PGPPacketDataInputStream in, PGPAlgorithmFactory factory) throws IOException, PGPFatalDataFormatException, PGPDataFormatException {
        PGPCompressorInputStream expander;
        short alg = in.readUnsignedByte();
        try {
            PGPCompressor cp = factory.getCompressionAlgorithm(alg);
            expander = cp.needsDummy() ? cp.getExpansionStream(new PGPZLibInputStreamAdapter(in)) : cp.getExpansionStream(new PGPInputStreamAdapter(in));
        }
        catch (NoSuchAlgorithmException nsae) {
            in.readByteArray();
            throw new PGPDataFormatException("id not found - " + nsae);
        }
        this.decodeSubPackets(expander, factory);
    }

    public void encodeBody(PGPPacketDataOutputStream out) throws IOException {
        PGPCompressorOutputStream compressor;
        int alg = this.getAlgorithmID();
        out.writeByte((byte)alg);
        try {
            PGPCompressor cp = PGPAlgorithmFactory.getDefaultInstance().getCompressionAlgorithm(alg);
            compressor = cp.getCompressionStream(new PGPOutputStreamAdapter(out));
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalArgumentException("id not found - " + nsae);
        }
        super.encodeSubPackets(compressor);
        compressor.finish();
    }

    public int getAlgorithmID() {
        return this.compAlgId;
    }

    public void setAlgorithmID(int id) {
        if (id > 255 || id < 0) {
            throw new IllegalArgumentException("Illegal algorithm id value: " + id);
        }
        this.compAlgId = id;
    }
}

