/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.packet;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPDecryptionFailedException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPEncryptor;
import cryptix.openpgp.io.PGPByteArrayDataInputStream;
import cryptix.openpgp.io.PGPByteArrayDataOutputStream;
import cryptix.openpgp.io.PGPPacketDataInputStream;
import cryptix.openpgp.io.PGPPacketDataOutputStream;
import cryptix.openpgp.packet.PGPSessionKey;
import cryptix.openpgp.packet.PGPSessionKeyPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;
import java.security.SecureRandom;

public class PGPPublicKeyEncryptedSessionKeyPacket
extends PGPSessionKeyPacket {
    private byte version;
    private byte datacipher;
    private int pubalgid;
    private byte[] sessionkey;
    private byte[] keyid;
    private byte[] encrypted;
    private PGPEncryptor encryptor;
    private boolean decrypted = false;

    public void decodeBody(PGPPacketDataInputStream in, PGPAlgorithmFactory factory) throws IOException, PGPFatalDataFormatException, PGPDataFormatException {
        this.version = in.readByte();
        if (this.version != 3 && this.version != 2) {
            in.readByteArray();
            throw new PGPDataFormatException("Unknown version for public key encrypted session key packet.");
        }
        this.keyid = new byte[8];
        in.readFully(this.keyid);
        this.pubalgid = in.readUnsignedByte();
        this.encrypted = in.readByteArray();
    }

    public void decrypt(PGPEncryptor cryptor) throws PGPDataFormatException, PGPDecryptionFailedException {
        PGPByteArrayDataInputStream badis = new PGPByteArrayDataInputStream(this.encrypted);
        try {
            cryptor.decodeEncryptedData(badis);
            badis.close();
        }
        catch (PGPFatalDataFormatException fdpe) {
            throw new PGPDataFormatException(fdpe.toString());
        }
        catch (IOException iOException) {
            throw new InternalError("IOException on byte array input stream.");
        }
        byte[] result = cryptor.decrypt();
        int sum = 0;
        int i = 1;
        while (i < result.length - 2) {
            sum += result[i] & 0xFF;
            ++i;
        }
        int expected = (result[result.length - 2] << 8 & 0xFF00) + (result[result.length - 1] & 0xFF);
        if (sum != expected) {
            throw new PGPDecryptionFailedException("Checksum mismatch");
        }
        this.datacipher = result[0];
        this.sessionkey = new byte[result.length - 3];
        System.arraycopy(result, 1, this.sessionkey, 0, this.sessionkey.length);
        this.decrypted = true;
    }

    public void encodeBody(PGPPacketDataOutputStream out) throws IOException {
        out.setLength(this.encrypted.length + 10);
        out.writeByte(this.version);
        out.writeFully(this.keyid);
        out.writeByte((byte)this.pubalgid);
        out.writeFully(this.encrypted);
    }

    public void encrypt(PGPEncryptor cryptor, SecureRandom sr) {
        byte[] data = new byte[this.sessionkey.length + 3];
        data[0] = this.datacipher;
        System.arraycopy(this.sessionkey, 0, data, 1, this.sessionkey.length);
        int sum = 0;
        int i = 1;
        while (i < data.length - 2) {
            sum += data[i] & 0xFF;
            ++i;
        }
        data[data.length - 2] = (byte)(sum >> 8 & 0xFF);
        data[data.length - 1] = (byte)(sum & 0xFF);
        cryptor.encrypt(data, sr);
        PGPByteArrayDataOutputStream bados = new PGPByteArrayDataOutputStream();
        try {
            cryptor.encodeEncryptedData(bados);
            bados.close();
        }
        catch (IOException iOException) {
            throw new InternalError("IOException on byte array output stream.");
        }
        this.encrypted = bados.toByteArray();
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPPublicKeyEncryptedSessionKeyPacket)) {
            return false;
        }
        PGPPublicKeyEncryptedSessionKeyPacket that = (PGPPublicKeyEncryptedSessionKeyPacket)ssp;
        return this.version == that.version && this.pubalgid == that.pubalgid && this.datacipher == that.datacipher && PGPCompare.equals(this.keyid, that.keyid) && PGPCompare.equals(this.encrypted, that.encrypted) && PGPCompare.equals(this.sessionkey, that.sessionkey);
    }

    public byte[] getKeyID() {
        return this.keyid;
    }

    public int getPublicKeyAlgorithmID() {
        return this.pubalgid;
    }

    public PGPSessionKey getSessionKey() {
        if (this.decrypted) {
            return new PGPSessionKey(this.sessionkey, this.datacipher);
        }
        throw new IllegalStateException("Data not decrypted yet.");
    }

    public void setKeyID(byte[] keyid) {
        this.keyid = keyid;
    }

    public void setPublicKeyAlgorithmID(int pubalgid) {
        this.pubalgid = pubalgid;
    }

    public void setSessionKey(byte[] sessionkey, byte datacipher) {
        this.sessionkey = sessionkey;
        this.datacipher = datacipher;
        this.version = (byte)3;
    }
}

