/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.openpgp.algorithm.PGPRSA;
import cryptix.openpgp.io.PGPHashDataOutputStream;
import cryptix.openpgp.packet.PGPKeyPacket;
import cryptix.openpgp.provider.PGPKeyIDFactory;
import cryptix.openpgp.util.PGPCompare;
import cryptix.pki.KeyID;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PGPKeyIDImpl
extends KeyID {
    private byte[] hash;
    private byte[] v3keyid;

    PGPKeyIDImpl(PGPKeyPacket pkt) {
        super("OpenPGP");
        if (pkt.getVersion() == 4) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError("SHA-1 hash algorithm not found");
            }
            PGPHashDataOutputStream hdos = new PGPHashDataOutputStream(md);
            try {
                pkt.encodeBody(hdos);
                hdos.close();
            }
            catch (IOException iOException) {
                throw new InternalError("IOException on calculating fingerprint");
            }
            this.hash = md.digest();
            this.v3keyid = null;
        } else if (pkt.getVersion() == 2 || pkt.getVersion() == 3) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError("MD5 hash algorithm not found");
            }
            md.update(((PGPRSA)pkt.getAlgorithm()).encodeV3FingerprintData());
            this.hash = md.digest();
            this.v3keyid = ((PGPRSA)pkt.getAlgorithm()).encodeV3KeyIDData();
        } else {
            throw new InternalError("Invalid version.");
        }
    }

    PGPKeyIDImpl(byte[] hash, byte[] keyid, int version) {
        super("OpenPGP");
        if (version == 4) {
            if (keyid != null && hash != null) {
                throw new IllegalArgumentException("Either keyid or hash should be null for V4");
            }
            if (keyid == null && hash == null) {
                throw new IllegalArgumentException("Either keyid or hash should not be null for V4");
            }
            if (hash != null) {
                if (hash.length != 20) {
                    throw new IllegalArgumentException("Hash length should be 160 bits");
                }
                this.hash = hash;
            } else {
                if (keyid.length != 8 && keyid.length != 4) {
                    throw new IllegalArgumentException("KeyID length should be 32 or 64 bits");
                }
                this.hash = keyid;
            }
        } else if (version == 3) {
            if (keyid == null) {
                throw new IllegalArgumentException("keyid should not be null for V3");
            }
            if (keyid.length != 8 && keyid.length != 4) {
                throw new IllegalArgumentException("KeyID length should be 32 or 64 bits");
            }
            this.v3keyid = keyid;
            if (hash != null) {
                if (hash.length != 16) {
                    throw new IllegalArgumentException("Hash length should be 128 bits");
                }
                this.hash = hash;
            }
        } else {
            throw new IllegalArgumentException("version should be 3 or 4");
        }
    }

    public Object clone() {
        if (this.v3keyid != null) {
            return new PGPKeyIDImpl(this.hash, this.v3keyid, 3);
        }
        return new PGPKeyIDImpl(this.hash, null, 4);
    }

    public boolean equals(Object other) {
        if (!(other instanceof PGPKeyIDImpl)) {
            return false;
        }
        PGPKeyIDImpl that = (PGPKeyIDImpl)((Object)other);
        return PGPCompare.equals(this.hash, that.hash) && PGPCompare.equals(this.v3keyid, that.v3keyid);
    }

    public byte[] getBytes() {
        return this.getBytes(this.getLength());
    }

    public byte[] getBytes(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        if (len > this.getLength()) {
            throw new IllegalArgumentException("len > getLength");
        }
        byte[] temp = new byte[len];
        if (this.v3keyid != null && len <= this.v3keyid.length) {
            System.arraycopy(this.v3keyid, this.v3keyid.length - len, temp, 0, len);
        } else {
            System.arraycopy(this.hash, this.hash.length - len, temp, 0, len);
        }
        return temp;
    }

    public int getLength() {
        if (this.hash != null) {
            return this.hash.length;
        }
        return this.v3keyid.length;
    }

    public boolean match(KeyID other) {
        if (!(other instanceof PGPKeyIDImpl)) {
            throw new IllegalArgumentException("invalid type");
        }
        PGPKeyIDImpl that = (PGPKeyIDImpl)other;
        if (this.v3keyid == null && that.v3keyid != null || this.v3keyid != null && that.v3keyid == null) {
            return false;
        }
        if (this.hash != null && that.hash != null) {
            int len = that.hash.length;
            if (len > this.hash.length) {
                len = this.hash.length;
            }
            int i = 0;
            while (i < len) {
                if (this.hash[this.hash.length - i - 1] != that.hash[that.hash.length - i - 1]) {
                    return false;
                }
                ++i;
            }
        } else {
            int len = that.v3keyid.length;
            if (len > this.v3keyid.length) {
                len = this.v3keyid.length;
            }
            int i = 0;
            while (i < len) {
                if (this.v3keyid[this.v3keyid.length - i - 1] != that.v3keyid[that.v3keyid.length - i - 1]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean match(Key other) {
        try {
            KeyID otherkeyid = PGPKeyIDFactory.convert(other);
            return this.match(otherkeyid);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("Invalid key");
        }
    }
}

