/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.custommonkey.xmlunit.ComparisonController;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceConstants;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.NodeDetail;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathNodeTracker;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DifferenceEngine
implements DifferenceConstants {
    private static final String NULL_NODE = "null";
    private static final String NOT_NULL_NODE = "not null";
    private static final String ATTRIBUTE_ABSENT = "[attribute absent]";
    private final ComparisonController controller;
    private final XpathNodeTracker controlTracker;
    private final XpathNodeTracker testTracker;
    private static final DifferenceFoundException flowControlException = new DifferenceFoundException();

    public DifferenceEngine(ComparisonController controller) {
        this.controller = controller;
        this.controlTracker = new XpathNodeTracker();
        this.testTracker = new XpathNodeTracker();
    }

    public void compare(Node control, Node test, DifferenceListener listener, ElementQualifier elementQualifier) {
        this.controlTracker.reset();
        this.testTracker.reset();
        try {
            this.compare(this.getNullOrNotNull(control), this.getNullOrNotNull(test), control, test, listener, NODE_TYPE);
            if (control != null) {
                this.compareNode(control, test, listener, elementQualifier);
            }
        }
        catch (DifferenceFoundException e) {
            // empty catch block
        }
    }

    private String getNullOrNotNull(Node aNode) {
        return aNode == null ? NULL_NODE : NOT_NULL_NODE;
    }

    protected void compareNode(Node control, Node test, DifferenceListener listener, ElementQualifier elementQualifier) throws DifferenceFoundException {
        boolean comparable = this.compareNodeBasics(control, test, listener);
        boolean isDocumentNode = false;
        if (comparable) {
            switch (control.getNodeType()) {
                case 1: {
                    this.compareElement((Element)control, (Element)test, listener);
                    break;
                }
                case 3: 
                case 4: {
                    this.compareText((CharacterData)control, (CharacterData)test, listener);
                    break;
                }
                case 8: {
                    this.compareComment((Comment)control, (Comment)test, listener);
                    break;
                }
                case 10: {
                    this.compareDocumentType((DocumentType)control, (DocumentType)test, listener);
                    break;
                }
                case 7: {
                    this.compareProcessingInstruction((ProcessingInstruction)control, (ProcessingInstruction)test, listener);
                    break;
                }
                case 9: {
                    isDocumentNode = true;
                    this.compareDocument((Document)control, (Document)test, listener, elementQualifier);
                    break;
                }
                default: {
                    listener.skippedComparison(control, test);
                }
            }
        }
        this.compareHasChildNodes(control, test, listener);
        if (isDocumentNode) {
            Element controlElement = ((Document)control).getDocumentElement();
            Element testElement = ((Document)test).getDocumentElement();
            if (controlElement != null && testElement != null) {
                this.compareNode(controlElement, testElement, listener, elementQualifier);
            }
        } else {
            this.controlTracker.indent();
            this.testTracker.indent();
            this.compareNodeChildren(control, test, listener, elementQualifier);
            this.controlTracker.outdent();
            this.testTracker.outdent();
        }
    }

    protected void compareDocument(Document control, Document test, DifferenceListener listener, ElementQualifier elementQualifier) throws DifferenceFoundException {
        DocumentType controlDoctype = control.getDoctype();
        DocumentType testDoctype = test.getDoctype();
        this.compare(this.getNullOrNotNull(controlDoctype), this.getNullOrNotNull(testDoctype), controlDoctype, testDoctype, listener, HAS_DOCTYPE_DECLARATION);
        if (controlDoctype != null && testDoctype != null) {
            this.compareNode(controlDoctype, testDoctype, listener, elementQualifier);
        }
    }

    protected boolean compareNodeBasics(Node control, Node test, DifferenceListener listener) throws DifferenceFoundException {
        this.controlTracker.visited(control);
        this.testTracker.visited(test);
        Short controlType = new Short(control.getNodeType());
        Short testType = new Short(test.getNodeType());
        boolean textAndCDATA = this.comparingTextAndCDATA(control.getNodeType(), test.getNodeType());
        if (!textAndCDATA) {
            this.compare(controlType, testType, control, test, listener, NODE_TYPE);
        }
        this.compare(control.getNamespaceURI(), test.getNamespaceURI(), control, test, listener, NAMESPACE_URI);
        this.compare(control.getPrefix(), test.getPrefix(), control, test, listener, NAMESPACE_PREFIX);
        return textAndCDATA || controlType.equals(testType);
    }

    private boolean comparingTextAndCDATA(short controlType, short testType) {
        return XMLUnit.getIgnoreDiffBetweenTextAndCDATA() && (controlType == 3 && testType == 4 || testType == 3 && controlType == 4);
    }

    protected void compareHasChildNodes(Node control, Node test, DifferenceListener listener) throws DifferenceFoundException {
        Boolean controlHasChildren = this.hasChildNodes(control);
        Boolean testHasChildren = this.hasChildNodes(test);
        this.compare(controlHasChildren, testHasChildren, control, test, listener, HAS_CHILD_NODES);
    }

    private Boolean hasChildNodes(Node n) {
        boolean flag = n.hasChildNodes();
        if (flag && XMLUnit.getIgnoreComments()) {
            List nl = DifferenceEngine.nodeList2List(n.getChildNodes());
            flag = !nl.isEmpty();
        }
        return flag ? Boolean.TRUE : Boolean.FALSE;
    }

    static List nodeList2List(NodeList nl) {
        int len = nl.getLength();
        ArrayList<Node> l = new ArrayList<Node>(len);
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (XMLUnit.getIgnoreComments() && n instanceof Comment) continue;
            l.add(n);
        }
        return l;
    }

    protected void compareNodeChildren(Node control, Node test, DifferenceListener listener, ElementQualifier elementQualifier) throws DifferenceFoundException {
        if (control.hasChildNodes() && test.hasChildNodes()) {
            List controlChildren = DifferenceEngine.nodeList2List(control.getChildNodes());
            List testChildren = DifferenceEngine.nodeList2List(test.getChildNodes());
            Integer controlLength = new Integer(controlChildren.size());
            Integer testLength = new Integer(testChildren.size());
            this.compare(controlLength, testLength, control, test, listener, CHILD_NODELIST_LENGTH);
            this.compareNodeList(controlChildren, testChildren, (int)controlLength, listener, elementQualifier);
        }
    }

    protected void compareNodeList(NodeList control, NodeList test, int numNodes, DifferenceListener listener, ElementQualifier elementQualifier) throws DifferenceFoundException {
        this.compareNodeList(DifferenceEngine.nodeList2List(control), DifferenceEngine.nodeList2List(test), numNodes, listener, elementQualifier);
    }

    protected void compareNodeList(List controlChildren, List testChildren, int numNodes, DifferenceListener listener, ElementQualifier elementQualifier) throws DifferenceFoundException {
        Node nextControl;
        int i;
        int j = 0;
        int lastTestNode = testChildren.size() - 1;
        this.testTracker.preloadChildList(testChildren);
        HashMap matchingNodes = new HashMap();
        HashMap<Node, Integer> matchingNodeIndexes = new HashMap<Node, Integer>();
        ArrayList unmatchedTestNodes = new ArrayList(testChildren);
        for (i = 0; i < numNodes; ++i) {
            int startAt;
            nextControl = (Node)controlChildren.get(i);
            boolean matchOnElement = nextControl instanceof Element;
            short findNodeType = nextControl.getNodeType();
            j = startAt = i > lastTestNode ? lastTestNode : i;
            boolean matchFound = false;
            while (!matchFound) {
                Node t = (Node)testChildren.get(j);
                if (findNodeType == t.getNodeType() || this.comparingTextAndCDATA(findNodeType, t.getNodeType())) {
                    boolean bl = matchFound = !matchOnElement || elementQualifier == null || elementQualifier.qualifyForComparison((Element)nextControl, (Element)t);
                }
                if (matchFound) continue;
                if (++j > lastTestNode) {
                    j = 0;
                }
                if (j != startAt) continue;
                break;
            }
            if (!matchFound) continue;
            matchingNodes.put(nextControl, testChildren.get(j));
            matchingNodeIndexes.put(nextControl, new Integer(j));
            unmatchedTestNodes.remove(testChildren.get(j));
        }
        for (i = 0; i < numNodes; ++i) {
            nextControl = (Node)controlChildren.get(i);
            Node nextTest = (Node)matchingNodes.get(nextControl);
            Integer testIndex = (Integer)matchingNodeIndexes.get(nextControl);
            if (nextTest == null && !unmatchedTestNodes.isEmpty()) {
                nextTest = (Node)unmatchedTestNodes.get(0);
                testIndex = new Integer(testChildren.indexOf(nextTest));
                unmatchedTestNodes.remove(0);
            }
            if (nextTest != null) {
                this.compareNode(nextControl, nextTest, listener, elementQualifier);
                this.compare(new Integer(i), testIndex, nextControl, nextTest, listener, CHILD_NODELIST_SEQUENCE);
                continue;
            }
            this.compare(nextControl.getNodeName(), null, nextControl, null, listener, CHILD_NODE_NOT_FOUND);
        }
        Iterator iter = unmatchedTestNodes.iterator();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            this.compare(null, n.getNodeName(), null, n, listener, CHILD_NODE_NOT_FOUND);
        }
    }

    private boolean isNamespaced(Node aNode) {
        String namespace = aNode.getNamespaceURI();
        return namespace != null && namespace.length() > 0;
    }

    protected void compareElement(Element control, Element test, DifferenceListener listener) throws DifferenceFoundException {
        this.compare(this.getUnNamespacedNodeName(control), this.getUnNamespacedNodeName(test), control, test, listener, ELEMENT_TAG_NAME);
        NamedNodeMap controlAttr = control.getAttributes();
        Integer controlNonXmlnsAttrLength = this.getNonSpecialAttrLength(controlAttr);
        NamedNodeMap testAttr = test.getAttributes();
        Integer testNonXmlnsAttrLength = this.getNonSpecialAttrLength(testAttr);
        this.compare(controlNonXmlnsAttrLength, testNonXmlnsAttrLength, control, test, listener, ELEMENT_NUM_ATTRIBUTES);
        this.compareElementAttributes(control, test, controlAttr, testAttr, listener);
    }

    private Integer getNonSpecialAttrLength(NamedNodeMap attributes) {
        int length = 0;
        int maxLength = attributes.getLength();
        for (int i = 0; i < maxLength; ++i) {
            Attr a = (Attr)attributes.item(i);
            if (this.isXMLNSAttribute(a) || this.isRecognizedXMLSchemaInstanceAttribute(a)) continue;
            ++length;
        }
        return new Integer(length);
    }

    void compareElementAttributes(Element control, Element test, NamedNodeMap controlAttr, NamedNodeMap testAttr, DifferenceListener listener) throws DifferenceFoundException {
        Attr nextAttr;
        int i;
        ArrayList<Attr> unmatchedTestAttrs = new ArrayList<Attr>();
        for (i = 0; i < testAttr.getLength(); ++i) {
            nextAttr = (Attr)testAttr.item(i);
            if (this.isXMLNSAttribute(nextAttr)) continue;
            unmatchedTestAttrs.add(nextAttr);
        }
        for (i = 0; i < controlAttr.getLength(); ++i) {
            nextAttr = (Attr)controlAttr.item(i);
            if (this.isXMLNSAttribute(nextAttr)) continue;
            boolean isNamespacedAttr = this.isNamespaced(nextAttr);
            String attrName = this.getUnNamespacedNodeName(nextAttr, isNamespacedAttr);
            Attr compareTo = null;
            compareTo = isNamespacedAttr ? (Attr)testAttr.getNamedItemNS(nextAttr.getNamespaceURI(), attrName) : (Attr)testAttr.getNamedItem(attrName);
            if (compareTo != null) {
                unmatchedTestAttrs.remove(compareTo);
            }
            if (this.isRecognizedXMLSchemaInstanceAttribute(nextAttr)) {
                this.compareRecognizedXMLSchemaInstanceAttribute(nextAttr, compareTo, listener);
                continue;
            }
            if (compareTo != null) {
                this.compareAttribute(nextAttr, compareTo, listener);
                if (XMLUnit.getIgnoreAttributeOrder()) continue;
                Attr attributeItem = (Attr)testAttr.item(i);
                String testAttrName = ATTRIBUTE_ABSENT;
                if (attributeItem != null) {
                    testAttrName = this.getUnNamespacedNodeName(attributeItem);
                }
                this.compare(attrName, testAttrName, nextAttr, compareTo, listener, ATTR_SEQUENCE);
                continue;
            }
            this.compare(attrName, null, control, test, listener, ATTR_NAME_NOT_FOUND);
        }
        Iterator iter = unmatchedTestAttrs.iterator();
        while (iter.hasNext()) {
            nextAttr = (Attr)iter.next();
            if (this.isRecognizedXMLSchemaInstanceAttribute(nextAttr)) {
                this.compareRecognizedXMLSchemaInstanceAttribute(null, nextAttr, listener);
                continue;
            }
            this.compare(null, this.getUnNamespacedNodeName(nextAttr, this.isNamespaced(nextAttr)), control, test, listener, ATTR_NAME_NOT_FOUND);
        }
        this.controlTracker.clearTrackedAttribute();
        this.testTracker.clearTrackedAttribute();
    }

    private String getUnNamespacedNodeName(Node aNode) {
        return this.getUnNamespacedNodeName(aNode, this.isNamespaced(aNode));
    }

    private String getUnNamespacedNodeName(Node aNode, boolean isNamespacedNode) {
        if (isNamespacedNode) {
            return aNode.getLocalName();
        }
        return aNode.getNodeName();
    }

    private boolean isXMLNSAttribute(Attr attribute) {
        return "xmlns".equals(attribute.getPrefix()) || "xmlns".equals(attribute.getName());
    }

    private boolean isRecognizedXMLSchemaInstanceAttribute(Attr attr) {
        return "http://www.w3.org/2001/XMLSchema-instance".equals(attr.getNamespaceURI()) && ("schemaLocation".equals(attr.getLocalName()) || "noNamespaceSchemaLocation".equals(attr.getLocalName()));
    }

    protected void compareRecognizedXMLSchemaInstanceAttribute(Attr control, Attr test, DifferenceListener listener) throws DifferenceFoundException {
        Difference d;
        Attr nonNullNode = control != null ? control : test;
        Difference difference = d = "schemaLocation".equals(nonNullNode.getLocalName()) ? SCHEMA_LOCATION : NO_NAMESPACE_SCHEMA_LOCATION;
        if (control != null) {
            this.controlTracker.visited(control);
        }
        if (test != null) {
            this.testTracker.visited(test);
        }
        this.compare(control != null ? control.getValue() : ATTRIBUTE_ABSENT, test != null ? test.getValue() : ATTRIBUTE_ABSENT, control, test, listener, d);
    }

    protected void compareAttribute(Attr control, Attr test, DifferenceListener listener) throws DifferenceFoundException {
        this.controlTracker.visited(control);
        this.testTracker.visited(test);
        this.compare(control.getPrefix(), test.getPrefix(), control, test, listener, NAMESPACE_PREFIX);
        this.compare(control.getValue(), test.getValue(), control, test, listener, ATTR_VALUE);
        this.compare(control.getSpecified() ? Boolean.TRUE : Boolean.FALSE, test.getSpecified() ? Boolean.TRUE : Boolean.FALSE, control, test, listener, ATTR_VALUE_EXPLICITLY_SPECIFIED);
    }

    protected void compareCDataSection(CDATASection control, CDATASection test, DifferenceListener listener) throws DifferenceFoundException {
        this.compareText(control, test, listener);
    }

    protected void compareComment(Comment control, Comment test, DifferenceListener listener) throws DifferenceFoundException {
        if (!XMLUnit.getIgnoreComments()) {
            this.compareCharacterData(control, test, listener, COMMENT_VALUE);
        }
    }

    protected void compareDocumentType(DocumentType control, DocumentType test, DifferenceListener listener) throws DifferenceFoundException {
        this.compare(control.getName(), test.getName(), control, test, listener, DOCTYPE_NAME);
        this.compare(control.getPublicId(), test.getPublicId(), control, test, listener, DOCTYPE_PUBLIC_ID);
        this.compare(control.getSystemId(), test.getSystemId(), control, test, listener, DOCTYPE_SYSTEM_ID);
    }

    protected void compareProcessingInstruction(ProcessingInstruction control, ProcessingInstruction test, DifferenceListener listener) throws DifferenceFoundException {
        this.compare(control.getTarget(), test.getTarget(), control, test, listener, PROCESSING_INSTRUCTION_TARGET);
        this.compare(control.getData(), test.getData(), control, test, listener, PROCESSING_INSTRUCTION_DATA);
    }

    protected void compareText(Text control, Text test, DifferenceListener listener) throws DifferenceFoundException {
        this.compareText((CharacterData)control, (CharacterData)test, listener);
    }

    protected void compareText(CharacterData control, CharacterData test, DifferenceListener listener) throws DifferenceFoundException {
        this.compareCharacterData(control, test, listener, control instanceof CDATASection ? CDATA_VALUE : TEXT_VALUE);
    }

    private void compareCharacterData(CharacterData control, CharacterData test, DifferenceListener listener, Difference difference) throws DifferenceFoundException {
        this.compare(control.getData(), test.getData(), control, test, listener, difference);
    }

    protected void compare(Object expected, Object actual, Node control, Node test, DifferenceListener listener, Difference difference) throws DifferenceFoundException {
        if (this.unequal(expected, actual)) {
            NodeDetail controlDetail = new NodeDetail(String.valueOf(expected), control, this.controlTracker.toXpathString());
            NodeDetail testDetail = new NodeDetail(String.valueOf(actual), test, this.testTracker.toXpathString());
            Difference differenceInstance = new Difference(difference, controlDetail, testDetail);
            listener.differenceFound(differenceInstance);
            if (this.controller.haltComparison(differenceInstance)) {
                throw flowControlException;
            }
        }
    }

    private boolean unequal(Object expected, Object actual) {
        return expected == null ? actual != null : this.unequalNotNull(expected, actual);
    }

    private boolean unequalNotNull(Object expected, Object actual) {
        if ((XMLUnit.getIgnoreWhitespace() || XMLUnit.getNormalizeWhitespace()) && expected instanceof String && actual instanceof String) {
            String expectedString = ((String)expected).trim();
            String actualString = ((String)actual).trim();
            if (XMLUnit.getNormalizeWhitespace()) {
                expectedString = DifferenceEngine.normalizeWhitespace(expectedString);
                actualString = DifferenceEngine.normalizeWhitespace(actualString);
            }
            return !expectedString.equals(actualString);
        }
        return !expected.equals(actual);
    }

    static final String normalizeWhitespace(String orig) {
        StringBuffer sb = new StringBuffer();
        boolean lastCharWasWhitespace = false;
        boolean changed = false;
        char[] characters = orig.toCharArray();
        for (int i = 0; i < characters.length; ++i) {
            if (Character.isWhitespace(characters[i])) {
                if (lastCharWasWhitespace) {
                    changed = true;
                    continue;
                }
                sb.append(' ');
                changed |= characters[i] != ' ';
                lastCharWasWhitespace = true;
                continue;
            }
            sb.append(characters[i]);
            lastCharWasWhitespace = false;
        }
        return changed ? sb.toString() : orig;
    }

    protected static final class DifferenceFoundException
    extends Exception {
        private DifferenceFoundException() {
            super("This exception is used to control flow");
        }
    }
}

