/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.BooleanOperations;
import de.odysseus.el.misc.NumberOperations;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import javax.el.ELContext;

public final class AstBinary
extends AstRightValue {
    public static final Operator ADD = new Operator(){

        public Object apply(Object object, Object object2) {
            return NumberOperations.add(object, object2);
        }

        public String toString() {
            return "+";
        }
    };
    public static final Operator AND = new Operator(){

        public Object apply(Object object, Object object2) {
            return BooleanOperations.and(object, object2);
        }

        public String toString() {
            return "&&";
        }
    };
    public static final Operator DIV = new Operator(){

        public Object apply(Object object, Object object2) {
            return NumberOperations.div(object, object2);
        }

        public String toString() {
            return "/";
        }
    };
    public static final Operator EQ = new Operator(){

        public Object apply(Object object, Object object2) {
            return BooleanOperations.eq(object, object2);
        }

        public String toString() {
            return "==";
        }
    };
    public static final Operator GE = new Operator(){

        public Object apply(Object object, Object object2) {
            return BooleanOperations.ge(object, object2);
        }

        public String toString() {
            return ">=";
        }
    };
    public static final Operator GT = new Operator(){

        public Object apply(Object object, Object object2) {
            return BooleanOperations.gt(object, object2);
        }

        public String toString() {
            return ">";
        }
    };
    public static final Operator LE = new Operator(){

        public Object apply(Object object, Object object2) {
            return BooleanOperations.le(object, object2);
        }

        public String toString() {
            return "<=";
        }
    };
    public static final Operator LT = new Operator(){

        public Object apply(Object object, Object object2) {
            return BooleanOperations.lt(object, object2);
        }

        public String toString() {
            return "<";
        }
    };
    public static final Operator MOD = new Operator(){

        public Object apply(Object object, Object object2) {
            return NumberOperations.mod(object, object2);
        }

        public String toString() {
            return "%";
        }
    };
    public static final Operator MUL = new Operator(){

        public Object apply(Object object, Object object2) {
            return NumberOperations.mul(object, object2);
        }

        public String toString() {
            return "*";
        }
    };
    public static final Operator NE = new Operator(){

        public Object apply(Object object, Object object2) {
            return BooleanOperations.ne(object, object2);
        }

        public String toString() {
            return "!=";
        }
    };
    public static final Operator OR = new Operator(){

        public Object apply(Object object, Object object2) {
            return BooleanOperations.or(object, object2);
        }

        public String toString() {
            return "||";
        }
    };
    public static final Operator SUB = new Operator(){

        public Object apply(Object object, Object object2) {
            return NumberOperations.sub(object, object2);
        }

        public String toString() {
            return "-";
        }
    };
    private final Operator operator;
    private final AstNode left;
    private final AstNode right;

    public AstBinary(AstNode astNode, AstNode astNode2, Operator operator) {
        this.left = astNode;
        this.right = astNode2;
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object eval(Bindings bindings, ELContext eLContext) {
        return this.operator.apply(this.left.eval(bindings, eLContext), this.right.eval(bindings, eLContext));
    }

    public String toString() {
        return "'" + this.operator.toString() + "'";
    }

    public void appendStructure(StringBuilder stringBuilder, Bindings bindings) {
        this.left.appendStructure(stringBuilder, bindings);
        stringBuilder.append(' ');
        stringBuilder.append(this.operator);
        stringBuilder.append(' ');
        this.right.appendStructure(stringBuilder, bindings);
    }

    public int getCardinality() {
        return 2;
    }

    public AstNode getChild(int n) {
        return n == 0 ? this.left : (n == 1 ? this.right : null);
    }

    public static interface Operator {
        public Object apply(Object var1, Object var2);
    }
}

