/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConversions;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.FunctionNode;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstFunction
extends AstRightValue
implements FunctionNode {
    private final String name;
    private final int index;
    private final List<AstNode> nodes;

    public AstFunction(String string, int n, List<AstNode> list) {
        this.nodes = list;
        this.name = string;
        this.index = n;
    }

    @Override
    public Object eval(Bindings bindings, ELContext eLContext) {
        Method method = bindings.getFunction(this.index);
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = null;
        if (classArray.length > 0) {
            objectArray = new Object[classArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = this.nodes.get(i).eval(bindings, eLContext);
                if (object == null && !classArray[i].isPrimitive()) continue;
                objectArray[i] = TypeConversions.coerceToType(object, classArray[i]);
            }
        }
        try {
            return method.invoke(null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ELException(LocalMessages.get("error.function.access", this.name), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ELException(LocalMessages.get("error.function.invocation", this.name), invocationTargetException.getCause());
        }
    }

    public String toString() {
        return this.name + "(...)";
    }

    @Override
    public void appendStructure(StringBuilder stringBuilder, Bindings bindings) {
        stringBuilder.append(bindings == null ? this.name : "<fn>");
        stringBuilder.append("(");
        if (this.getCardinality() > 0) {
            this.nodes.get(0).appendStructure(stringBuilder, bindings);
            for (int i = 1; i < this.getCardinality(); ++i) {
                stringBuilder.append(", ");
                this.nodes.get(i).appendStructure(stringBuilder, bindings);
            }
        }
        stringBuilder.append(")");
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getParamCount() {
        return this.getCardinality();
    }

    @Override
    public int getCardinality() {
        return this.nodes == null ? 0 : this.nodes.size();
    }

    @Override
    public AstNode getChild(int n) {
        return this.nodes == null ? null : this.nodes.get(n);
    }
}

