/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConversions;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstProperty
extends AstNode {
    private final AstNode prefix;
    private final boolean lvalue;
    private final boolean strict;

    public AstProperty(AstNode astNode, boolean bl, boolean bl2) {
        this.prefix = astNode;
        this.lvalue = bl;
        this.strict = bl2;
    }

    protected abstract Object getProperty(Bindings var1, ELContext var2) throws ELException;

    @Override
    public final Object eval(Bindings bindings, ELContext eLContext) {
        Object object = this.prefix.eval(bindings, eLContext);
        if (object == null) {
            return null;
        }
        Object object2 = this.getProperty(bindings, eLContext);
        if (object2 == null && this.strict) {
            return null;
        }
        Object object3 = eLContext.getELResolver().getValue(eLContext, object, object2);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", object2, object));
        }
        return object3;
    }

    @Override
    public final boolean isLiteralText() {
        return false;
    }

    @Override
    public final boolean isLeftValue() {
        return this.lvalue;
    }

    @Override
    public final Class<?> getType(Bindings bindings, ELContext eLContext) {
        if (!this.lvalue) {
            return null;
        }
        Object object = this.prefix.eval(bindings, eLContext);
        if (object == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", this.prefix));
        }
        Object object2 = this.getProperty(bindings, eLContext);
        if (object2 == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", "null", object));
        }
        Class<?> clazz = eLContext.getELResolver().getType(eLContext, object, object2);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", object2, object));
        }
        return clazz;
    }

    @Override
    public final boolean isReadOnly(Bindings bindings, ELContext eLContext) throws ELException {
        if (!this.lvalue) {
            return true;
        }
        Object object = this.prefix.eval(bindings, eLContext);
        if (object == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", this.prefix));
        }
        Object object2 = this.getProperty(bindings, eLContext);
        if (object2 == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", "null", object));
        }
        boolean bl = eLContext.getELResolver().isReadOnly(eLContext, object, object2);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", object2, object));
        }
        return bl;
    }

    @Override
    public final void setValue(Bindings bindings, ELContext eLContext, Object object) throws ELException {
        if (!this.lvalue) {
            throw new ELException(LocalMessages.get("error.value.set.rvalue", new Object[0]));
        }
        Object object2 = this.prefix.eval(bindings, eLContext);
        if (object2 == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", this.prefix));
        }
        Object object3 = this.getProperty(bindings, eLContext);
        if (object3 == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", "null", object2));
        }
        eLContext.getELResolver().setValue(eLContext, object2, object3, object);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", object3, object2));
        }
    }

    private Method findMethod(String string, Class<?> clazz, Class<?> clazz2, Class<?>[] classArray) {
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", string, clazz));
        }
        if (clazz2 != null && !clazz2.isAssignableFrom(method.getReturnType())) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", string, clazz));
        }
        return method;
    }

    @Override
    public final MethodInfo getMethodInfo(Bindings bindings, ELContext eLContext, Class<?> clazz, Class<?>[] classArray) {
        Object object = this.prefix.eval(bindings, eLContext);
        if (object == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", this.prefix));
        }
        Object object2 = this.getProperty(bindings, eLContext);
        if (object2 == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.method.notfound", "null", object));
        }
        String string = TypeConversions.coerceToString(object2);
        Method method = this.findMethod(string, object.getClass(), clazz, classArray);
        return new MethodInfo(method.getName(), method.getReturnType(), classArray);
    }

    @Override
    public final Object invoke(Bindings bindings, ELContext eLContext, Class<?> clazz, Class<?>[] classArray, Object[] objectArray) {
        Object object = this.prefix.eval(bindings, eLContext);
        if (object == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", this.prefix));
        }
        Object object2 = this.getProperty(bindings, eLContext);
        if (object2 == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.method.notfound", "null", object));
        }
        String string = TypeConversions.coerceToString(object2);
        Method method = this.findMethod(string, object.getClass(), clazz, classArray);
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ELException(LocalMessages.get("error.property.method.access", string, object.getClass()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ELException(LocalMessages.get("error.property.method.invocation", string, object.getClass()), illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ELException(LocalMessages.get("error.property.method.invocation", string, object.getClass()), invocationTargetException.getCause());
        }
    }

    @Override
    public AstNode getChild(int n) {
        return n == 0 ? this.prefix : null;
    }
}

