/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.construct;

import java.net.InetAddress;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MessageExchangePattern;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.MessageSource;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.construct.processor.FlowConstructStatisticsMessageObserver;
import org.mule.interceptor.LoggingInterceptor;
import org.mule.processor.StopFurtherMessageProcessingMessageProcessor;
import org.mule.processor.builder.InterceptingChainMessageProcessorBuilder;
import org.mule.transformer.TransformerTemplate;
import org.mule.util.ObjectUtils;
import org.mule.util.StringUtils;

public class WSProxy
extends AbstractFlowConstruct {
    private final AbstractProxyRequestProcessor proxyMessageProcessor;
    private final OutboundEndpoint outboundEndpoint;

    public WSProxy(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint) throws MuleException {
        this(name, muleContext, messageSource, outboundEndpoint, new DynamicWsdlProxyRequestProcessor(outboundEndpoint));
    }

    public WSProxy(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, String wsdlContents) throws MuleException {
        this(name, muleContext, messageSource, outboundEndpoint, new StaticWsdlProxyRequestProcessor(wsdlContents));
    }

    public WSProxy(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, URI wsdlUri) throws MuleException {
        this(name, muleContext, messageSource, outboundEndpoint, new DynamicWsdlProxyRequestProcessor(wsdlUri));
    }

    private WSProxy(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, AbstractProxyRequestProcessor proxyMessageProcessor) throws MuleException {
        super(name, muleContext);
        if (messageSource == null) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("messageSource can't be null on: " + this.toString()), this);
        }
        super.setMessageSource(messageSource);
        if (outboundEndpoint == null) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("outboundEndpoint can't be null on: " + this.toString()), this);
        }
        this.outboundEndpoint = outboundEndpoint;
        this.proxyMessageProcessor = proxyMessageProcessor;
    }

    protected void configureMessageProcessors(InterceptingChainMessageProcessorBuilder builder) {
        builder.chain(new LoggingInterceptor());
        builder.chain(new FlowConstructStatisticsMessageObserver());
        builder.chain(this.proxyMessageProcessor);
        builder.chain(new StopFurtherMessageProcessingMessageProcessor());
        builder.chain(new TransformerTemplate(new CopyInboundToOutboundPropertiesTransformerCallback()));
        builder.chain(this.outboundEndpoint);
    }

    protected void validateConstruct() throws FlowConstructInvalidException {
        super.validateConstruct();
        if (this.messageSource instanceof InboundEndpoint && !((InboundEndpoint)this.messageSource).getExchangePattern().equals((Object)MessageExchangePattern.REQUEST_RESPONSE)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("WSProxy only works with a request-response inbound endpoint."), this);
        }
        if (!this.outboundEndpoint.getExchangePattern().equals((Object)MessageExchangePattern.REQUEST_RESPONSE)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("WSProxy only works with a request-response outbound endpoint."), this);
        }
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }

    private static class DynamicWsdlProxyRequestProcessor
    extends AbstractProxyRequestProcessor {
        private static final String LOCALHOST = "localhost";
        private final String wsdlAddress;

        DynamicWsdlProxyRequestProcessor(URI wsdlUri) throws FlowConstructInvalidException {
            if (wsdlUri == null) {
                throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("wsdlUri can't be null"));
            }
            this.wsdlAddress = wsdlUri.toString();
            this.logger.info((Object)("Using url " + this.wsdlAddress + " as WSDL"));
        }

        DynamicWsdlProxyRequestProcessor(OutboundEndpoint outboundEndpoint) throws FlowConstructInvalidException {
            if (outboundEndpoint == null) {
                throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("outboundEndpoint can't be null"));
            }
            String urlWebservice = outboundEndpoint.getEndpointURI().getUri().toString();
            int paramIndex = urlWebservice.indexOf("?");
            if (paramIndex != -1) {
                urlWebservice = urlWebservice.substring(0, paramIndex);
            }
            this.wsdlAddress = urlWebservice.concat("?wsdl");
            this.logger.info((Object)("Setting WSDL address to: " + this.wsdlAddress));
        }

        protected String getWsdlContents(MuleEvent event) throws Exception {
            String proxyWsdlAddress;
            MuleContext muleContext = event.getMuleContext();
            InboundEndpoint webServiceEndpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(this.wsdlAddress);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving WSDL from web service with: " + webServiceEndpoint));
            }
            MuleMessage replyWSDL = webServiceEndpoint.request(event.getTimeout());
            String wsdlString = replyWSDL.getPayloadAsString();
            String realWsdlAddress = this.wsdlAddress.split("\\?")[0];
            if ((wsdlString = wsdlString.replaceAll(realWsdlAddress, proxyWsdlAddress = event.getEndpoint().getEndpointURI().getUri().toString())).indexOf(LOCALHOST) > -1) {
                wsdlString = wsdlString.replaceAll(LOCALHOST, InetAddress.getLocalHost().getHostName());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"WSDL retrieved successfully");
            }
            return wsdlString;
        }
    }

    private static class StaticWsdlProxyRequestProcessor
    extends AbstractProxyRequestProcessor {
        private final String wsdlContents;

        StaticWsdlProxyRequestProcessor(String wsdlContents) throws FlowConstructInvalidException {
            if (StringUtils.isBlank((String)wsdlContents)) {
                throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("wsdlContents can't be empty"));
            }
            this.wsdlContents = wsdlContents;
        }

        protected String getWsdlContents(MuleEvent event) throws Exception {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Serving static WSDL");
            }
            return this.wsdlContents;
        }
    }

    private static abstract class AbstractProxyRequestProcessor
    implements MessageProcessor {
        private static final String HTTP_REQUEST = "http.request";
        private static final String WSDL_PARAM_1 = "?wsdl";
        private static final String WSDL_PARAM_2 = "&wsdl";
        protected final Log logger = LogFactory.getLog(WSProxy.class);

        private AbstractProxyRequestProcessor() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            if (this.isWsdlRequest(event)) {
                return this.buildWsdlResult(event);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Forwarding SOAP message");
            }
            return event;
        }

        private MuleEvent buildWsdlResult(MuleEvent event) throws MuleException {
            try {
                String wsdlContents = this.getWsdlContents(event);
                event.getMessage().setPayload(wsdlContents);
                event.setStopFurtherProcessing(true);
                return event;
            }
            catch (Exception e) {
                throw new MessagingException(MessageFactory.createStaticMessage("Impossible to retrieve WSDL for proxied service"), event, (Throwable)e);
            }
        }

        private boolean isWsdlRequest(MuleEvent event) throws MuleException {
            String httpRequest = (String)event.getMessage().getInboundProperty(HTTP_REQUEST);
            if (httpRequest == null) {
                this.logger.warn((Object)("WS Proxy can't rewrite WSDL for non-HTTP " + event));
                return false;
            }
            String lowerHttpRequest = httpRequest.toLowerCase();
            return lowerHttpRequest.indexOf(WSDL_PARAM_1) != -1 || lowerHttpRequest.indexOf(WSDL_PARAM_2) != -1;
        }

        protected abstract String getWsdlContents(MuleEvent var1) throws Exception;
    }

    private static final class CopyInboundToOutboundPropertiesTransformerCallback
    implements TransformerTemplate.TransformerCallback {
        private CopyInboundToOutboundPropertiesTransformerCallback() {
        }

        public Object doTransform(MuleMessage message) throws Exception {
            for (String inboundPropertyName : message.getInboundPropertyNames()) {
                message.setOutboundProperty(inboundPropertyName, message.getInboundProperty(inboundPropertyName));
            }
            return message;
        }
    }
}

