/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.spi.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.DefaultInboundEndpoint;
import org.mule.endpoint.DynamicURIInboundEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.endpoint.URIBuilder;
import org.mule.transport.service.TransportFactory;
import org.mule.transport.service.TransportFactoryException;
import org.mule.util.TemplateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicRequestEndpoint
extends DynamicURIInboundEndpoint {
    public static final String EVAL_PARAM_PROPERTY = "eval.param";
    protected final transient Log logger = LogFactory.getLog(DynamicRequestEndpoint.class);
    private static final long serialVersionUID = 8861985949279708638L;
    protected TemplateParser parser = TemplateParser.createCurlyBracesStyleParser();
    protected String uriTemplate;
    private EndpointBuilder builder;

    public DynamicRequestEndpoint(MuleContext muleContext, EndpointBuilder builder, String uriTemplate) throws MalformedEndpointException {
        super((InboundEndpoint)new NullInboundEndpoint(muleContext));
        this.builder = builder;
        this.uriTemplate = uriTemplate;
        this.validateUriTemplate(uriTemplate);
    }

    protected void validateUriTemplate(String uri) throws MalformedEndpointException {
        if (uri.indexOf(":") > uri.indexOf("#[")) {
            throw new MalformedEndpointException(CoreMessages.dynamicEndpointsMustSpecifyAScheme(), uri);
        }
    }

    protected Map<String, Object> getPropertiesForTemplate(MuleMessage message) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(this.getProperties());
        for (String propertyKey : message.getOutboundPropertyNames()) {
            props.put(propertyKey, message.getOutboundProperty(propertyKey));
        }
        return props;
    }

    protected EndpointURI getEndpointURIForMessage(MuleEvent event) throws MessagingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri before parsing is: " + this.uriTemplate));
        }
        Map<String, Object> props = this.getPropertiesForTemplate(event.getMessage());
        String newUriString = this.parser.parse(props, this.uriTemplate);
        Object evalParam = props.get(EVAL_PARAM_PROPERTY);
        newUriString = evalParam != null ? this.parseURIString(newUriString, (MuleMessage)new DefaultMuleMessage(evalParam, this.getMuleContext())) : this.parseURIString(newUriString, event.getMessage());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri after parsing is: " + newUriString));
        }
        try {
            this.setEndpointURI((EndpointURI)new MuleEndpointURI(newUriString, this.getMuleContext()));
            if (!newUriString.startsWith(this.getEndpointURI().getScheme())) {
                throw new MessagingException(CoreMessages.schemeCannotChangeForRouter((String)this.getEndpointURI().getScheme(), (String)this.getEndpointURI().getScheme()), event);
            }
            this.getEndpointURI().initialise();
            return this.getEndpointURI();
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.templateCausedMalformedEndpoint((String)this.uriTemplate, (String)newUriString), event, (Throwable)e);
        }
    }

    protected String parseURIString(String uri, MuleMessage message) {
        return this.getMuleContext().getExpressionManager().parse(uri, message, true);
    }

    public MuleMessage request(long timeout, MuleEvent event) throws Exception {
        EndpointURI uri = this.getEndpointURIForMessage(event);
        if (this.endpoint instanceof NullInboundEndpoint) {
            this.builder.setURIBuilder(new URIBuilder(uri));
            this.endpoint = this.builder.buildInboundEndpoint();
        }
        DynamicURIInboundEndpoint inboundEndpoint = new DynamicURIInboundEndpoint(this.endpoint, uri);
        if (event.getMessage().getInvocationProperty("MULE_CREDENTIALS") != null) {
            inboundEndpoint.getProperties().put("MULE_CREDENTIALS", event.getMessage().getInvocationProperty("MULE_CREDENTIALS"));
        }
        return super.request(timeout);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DynamicRequestEndpoint that = (DynamicRequestEndpoint)((Object)o);
        return !(this.uriTemplate == null ? that.uriTemplate != null : !this.uriTemplate.equals(that.uriTemplate));
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.uriTemplate != null ? this.uriTemplate.hashCode() : 0);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NullInboundEndpoint
    extends DefaultInboundEndpoint
    implements InboundEndpoint {
        NullInboundEndpoint(MuleContext muleContext) {
            super(NullInboundEndpoint.createDynamicConnector(muleContext), null, null, new HashMap(), null, true, MessageExchangePattern.ONE_WAY, 0, "started", null, null, muleContext, null, null, null, null, true, null);
        }

        public MessageProcessor createMessageProcessorChain(FlowConstruct flowContruct) throws MuleException {
            throw new UnsupportedOperationException("createMessageProcessorChain");
        }

        public List<String> getResponseProperties() {
            return Collections.emptyList();
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            throw new UnsupportedOperationException("process");
        }

        static Connector createDynamicConnector(MuleContext muleContext) {
            try {
                return new TransportFactory(muleContext).createConnector("dynamic://endpoint");
            }
            catch (TransportFactoryException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }
}

