/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ibean;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.ibeans.annotation.State;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.ibeans.config.IBeanHolder;
import org.mule.module.ibeans.spi.MuleIBeansPlugin;
import org.mule.transport.AbstractConnector;
import org.mule.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBeansConnector
extends AbstractConnector {
    public static final String STATE_PARAMS_PROPERTY = "ibean.state.params";
    public static final String CALL_PARAMS_PROPERTY = "ibean.call.params";
    private MuleIBeansPlugin iBeansPlugin;
    public static final String PROTOCOL = "ibean";

    public IBeansConnector(MuleContext context) {
        super(context);
        this.iBeansPlugin = new MuleIBeansPlugin(context);
    }

    public void doInitialise() throws InitialisationException {
    }

    public void doConnect() throws Exception {
    }

    public void doDisconnect() throws Exception {
    }

    public void doStart() throws MuleException {
    }

    public void doStop() throws MuleException {
    }

    public void doDispose() {
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public MuleIBeansPlugin getiBeansPlugin() {
        return this.iBeansPlugin;
    }

    public void setiBeansPlugin(MuleIBeansPlugin iBeansPlugin) {
        this.iBeansPlugin = iBeansPlugin;
    }

    Object createIbean(EndpointURI uri, List<?> state) throws MuleException {
        try {
            String address = uri.getAddress();
            int i = address.indexOf(".");
            String ibeanName = address.substring(0, i);
            IBeanHolder holder = (IBeanHolder)this.getMuleContext().getRegistry().lookupObject(ibeanName);
            if (holder == null) {
                throw new IllegalArgumentException();
            }
            Object ibean = holder.create(this.getMuleContext(), this.getiBeansPlugin());
            if (state.size() > 0) {
                Class[] types = new Class[state.size()];
                Object[] params = new Object[state.size()];
                int x = 0;
                for (Object o : state) {
                    types[x] = o.getClass();
                    params[x++] = o;
                }
                List methods = ClassUtils.getSatisfiableMethods((Class)holder.getIbeanClass(), (Class[])types, (boolean)true, (boolean)false, Collections.emptyList(), null);
                if (methods.size() == 0) {
                    throw new IllegalArgumentException("no matching methods");
                }
                if (methods.size() == 1) {
                    if (((Method)methods.get(0)).isAnnotationPresent(State.class)) {
                        ((Method)methods.get(0)).invoke(ibean, params);
                    }
                } else {
                    boolean match = false;
                    for (Method method1 : methods) {
                        if (!method1.isAnnotationPresent(State.class)) continue;
                        method1.invoke(ibean, params);
                        match = true;
                        break;
                    }
                    if (!match) {
                        throw new IllegalArgumentException("no matching @State method");
                    }
                }
            }
            return ibean;
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }
}

