/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ibeans.api.CallInterceptor;
import org.ibeans.api.InvocationContext;
import org.ibeans.impl.auth.OAuthAuthentication;
import org.scribe.oauth.Scribe;
import org.scribe.oauth.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OAuthCallInterceptor
implements CallInterceptor {
    public static final String OAUTH_REQUEST_TOKEN = "oauth.request.token";
    private Map<String, Object> store = new HashMap<String, Object>();

    public OAuthCallInterceptor(Map<String, Object> store) {
        this.store = store;
    }

    @Override
    public void intercept(InvocationContext invocationContext) {
        Log logger = LogFactory.getLog(OAuthCallInterceptor.class);
        if (invocationContext.getMethod().getDeclaringClass().equals(OAuthAuthentication.class)) {
            Token requestToken;
            Scribe scribe;
            Properties props;
            if (invocationContext.getMethod().getName().equals("getOAuthAuthenticateURL")) {
                props = new Properties();
                props.putAll(invocationContext.getIBeanConfig().getPropertyParams());
                scribe = new Scribe(props);
                requestToken = scribe.getRequestToken();
                invocationContext.getIBeanDefaultConfig().getPropertyParams().put(OAUTH_REQUEST_TOKEN, requestToken);
                String authURL = (String)invocationContext.getIBeanConfig().getPropertyParams().get("oauth.request.token.url");
                URL url = null;
                try {
                    url = new URL(authURL.replace(OAUTH_REQUEST_TOKEN, requestToken.getToken()));
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                System.out.println("OAuth URL for ibean is: " + url);
                invocationContext.setResult(url);
            }
            if (invocationContext.getMethod().getName().equals("verify")) {
                props = new Properties();
                props.putAll(invocationContext.getIBeanConfig().getPropertyParams());
                scribe = new Scribe(props);
                requestToken = (Token)invocationContext.getIBeanDefaultConfig().getPropertyParams().get(OAUTH_REQUEST_TOKEN);
                String pin = (String)invocationContext.getIBeanConfig().getPropertyParams().get("pin");
                String user = (String)invocationContext.getIBeanConfig().getPropertyParams().get("userKey");
                Token accessToken = scribe.getAccessToken(requestToken, pin);
                logger.info((Object)("Access token received from LinkedIn: " + accessToken));
                this.store.put(user, accessToken);
            }
        } else {
            invocationContext.proceed();
        }
    }
}

